/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.fruitsdelight.init.data.FDModConfig;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLeavesBlock
extends LeavesBlock {
    public BaseLeavesBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected boolean canPassThrough(@Nullable Entity e) {
        if (e == null) {
            return false;
        }
        if (e instanceof ItemEntity) {
            return true;
        }
        return e instanceof FallingBlockEntity;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return InteractionResult.PASS;
        }
        return this.doClick(level, pos, state);
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (((Boolean)pState.getValue((Property)PERSISTENT)).booleanValue()) {
            return;
        }
        this.doClick(pLevel, pPos, pState);
    }

    protected abstract InteractionResult doClick(Level var1, BlockPos var2, BlockState var3);

    @Nullable
    protected BlockPos findNextFlowerTarget(Level level, BlockPos pos, Predicate<BlockState> pred) {
        if ((Double)FDModConfig.SERVER.flowerDecayChance.get() > level.getRandom().nextDouble()) {
            return null;
        }
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (Direction e : Direction.values()) {
            BlockPos ipos = pos.relative(e);
            BlockState istate = level.getBlockState(ipos);
            if (!istate.is((Block)this) || !pred.test(istate)) continue;
            builder.add((Object)ipos, (Integer)istate.getValue((Property)DISTANCE) + 2);
        }
        return builder.build().getRandomValue(level.random).orElse(null);
    }

    @Deprecated
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        EntityCollisionContext ectx;
        if (ctx instanceof EntityCollisionContext && this.canPassThrough((ectx = (EntityCollisionContext)ctx).getEntity())) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, ctx);
    }

    public abstract void buildLeavesModel(DataGenContext<Block, ? extends BaseLeavesBlock> var1, RegistrateBlockstateProvider var2, String var3);

    public abstract void buildLoot(RegistrateBlockLootTables var1, Block var2, Block var3, Item var4);

    public abstract BlockState flowerState();
}

