/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.content.block.PassableLeavesBlock;
import dev.xkmc.fruitsdelight.init.data.FDModConfig;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;

public class PeachLeavesBlock
extends PassableLeavesBlock {
    public static final BooleanProperty FERTILE = BooleanProperty.create((String)"fertile");

    public PeachLeavesBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FERTILE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FERTILE});
        super.createBlockStateDefinition(builder);
    }

    private List<BlockPos> scanLeaves(Level level, BlockPos pos) {
        ArrayList<BlockPos> ans = new ArrayList<BlockPos>();
        BlockState state = level.getBlockState(pos);
        if (!state.is((Block)this)) {
            return ans;
        }
        int dist = (Integer)state.getValue((Property)DISTANCE);
        if (dist > 1) {
            return ans;
        }
        BlockState log = level.getBlockState(pos = pos.below());
        if (!log.is(BlockTags.LOGS)) {
            return ans;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(Pair.of((Object)-1, (Object)pos));
        while (!queue.isEmpty()) {
            Pair e = (Pair)queue.poll();
            for (Direction dir : Direction.values()) {
                int ndis;
                BlockPos npos = ((BlockPos)e.getSecond()).relative(dir);
                if (visited.contains(npos)) continue;
                visited.add(npos);
                BlockState nst = level.getBlockState(npos);
                if (!nst.is((Block)this) || ((Boolean)nst.getValue((Property)PERSISTENT)).booleanValue() || (ndis = ((Integer)nst.getValue((Property)DISTANCE)).intValue()) < (Integer)e.getFirst()) continue;
                queue.add(Pair.of((Object)ndis, (Object)npos));
                ans.add(npos);
            }
        }
        return ans;
    }

    @Override
    public boolean isRandomlyTicking(BlockState state) {
        if (((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            return false;
        }
        if (state.getValue((Property)STATE) == PassableLeavesBlock.State.FRUITS) {
            return true;
        }
        if (((Boolean)state.getValue((Property)FERTILE)).booleanValue() && (Integer)state.getValue((Property)DISTANCE) == 1) {
            return true;
        }
        return (Integer)state.getValue((Property)DISTANCE) == 7;
    }

    @Override
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && !this.decaying(state)) {
            boolean grow;
            PassableLeavesBlock.State st = (PassableLeavesBlock.State)((Object)state.getValue((Property)STATE));
            if (st == PassableLeavesBlock.State.LEAVES && ((Boolean)state.getValue((Property)FERTILE)).booleanValue() && (Integer)state.getValue((Property)DISTANCE) == 1) {
                boolean bl = grow = random.nextDouble() < (Double)FDModConfig.SERVER.peachGrowChance.get();
                if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    List<BlockPos> list = this.scanLeaves((Level)level, pos);
                    for (BlockPos e : list) {
                        BlockState est = level.getBlockState(e);
                        est = (BlockState)est.setValue((Property)STATE, (Comparable)((Object)PassableLeavesBlock.State.FLOWERS));
                        level.setBlockAndUpdate(e, est);
                    }
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    return;
                }
            }
            if (st == PassableLeavesBlock.State.FLOWERS) {
                boolean bl = grow = random.nextDouble() < (Double)FDModConfig.SERVER.peachGrowChance.get();
                if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    List<BlockPos> list = this.scanLeaves((Level)level, pos);
                    for (BlockPos e : list) {
                        BlockState est = level.getBlockState(e);
                        if (est.getValue((Property)STATE) == PassableLeavesBlock.State.FRUITS) {
                            this.doDropFruit(est, level, e);
                        }
                        if ((Integer)(est = random.nextDouble() < (Double)FDModConfig.SERVER.peachFruitChance.get() ? (BlockState)est.setValue((Property)STATE, (Comparable)((Object)PassableLeavesBlock.State.FRUITS)) : (BlockState)est.setValue((Property)STATE, (Comparable)((Object)PassableLeavesBlock.State.LEAVES))).getValue((Property)DISTANCE) > 1 || e.equals((Object)pos) && random.nextDouble() < (Double)FDModConfig.SERVER.flowerDecayChance.get()) {
                            est = (BlockState)est.setValue((Property)FERTILE, (Comparable)Boolean.valueOf(false));
                        }
                        level.setBlockAndUpdate(e, est);
                    }
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
                return;
            }
            if (st == PassableLeavesBlock.State.FRUITS) {
                if (random.nextDouble() < (Double)FDModConfig.SERVER.fruitsDropChance.get()) {
                    this.dropFruit(state, level, pos, random);
                }
                return;
            }
        }
        super.randomTick(state, level, pos, random);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT);
    }

    @Override
    public void buildLeavesModel(DataGenContext<Block, ? extends BaseLeavesBlock> ctx, RegistrateBlockstateProvider pvd, String name) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(state -> this.buildModel(pvd, name, (BlockState)state), new Property[]{DISTANCE, PERSISTENT, WATERLOGGED, FERTILE});
    }
}

