/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.fruitsdelight.content.block.BaseBushBlock;
import dev.xkmc.fruitsdelight.content.block.BushFruitItem;
import dev.xkmc.fruitsdelight.content.block.FruitBushBlock;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.FDBushType;
import dev.xkmc.fruitsdelight.init.plants.FruitPlant;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import dev.xkmc.l2core.serial.loot.LootHelper;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;

public enum FDBushes implements FruitPlant<FDBushes>
{
    BLUEBERRY(2, 0.3f, true, 32, FDBushType.BLOCK),
    LEMON(4, 0.3f, false, 32, FDBushType.TALL),
    CRANBERRY(2, 0.3f, true, 32, FDBushType.CROSS);

    private final BlockEntry<? extends BushBlock> bush;
    private final ItemEntry<BushFruitItem> seedItem;
    private final ItemEntry<Item> mid;
    private final int rarity;
    private final FDBushType type;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKey;
    public final ResourceKey<PlacedFeature> placementKey;

    private FDBushes(int food, float sat, boolean fast, int rarity, FDBushType type) {
        String name = this.name().toLowerCase(Locale.ROOT);
        String suffix = type == FDBushType.TALL ? "tree" : "bush";
        this.configKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)FruitsDelight.loc(name + "_" + suffix));
        this.placementKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)FruitsDelight.loc(name + "_" + suffix));
        this.rarity = rarity;
        this.type = type;
        this.bush = type.build(name + "_" + suffix, this);
        if (type == FDBushType.TALL) {
            this.mid = ((ItemBuilder)FruitsDelight.REGISTRATE.item(name, p -> new Item(p.food(FDBushes.food(food, sat, fast)))).transform(b -> PlantDataEntry.addFruitTags(name, b))).register();
            this.seedItem = FruitsDelight.REGISTRATE.item(name + "_seeds", p -> new BushFruitItem((Block)this.getBush(), (Item.Properties)p)).register();
        } else {
            this.mid = null;
            this.seedItem = ((ItemBuilder)FruitsDelight.REGISTRATE.item(name, p -> new BushFruitItem((Block)this.getBush(), p.food(FDBushes.food(food, sat, fast)))).transform(b -> PlantDataEntry.addFruitTags(name, b))).register();
        }
    }

    @Override
    public void registerComposter(BiConsumer<Item, Float> builder) {
        if (this.type == FDBushType.TALL) {
            builder.accept((Item)this.mid.get(), Float.valueOf(0.35f));
        }
        builder.accept((Item)this.seedItem.get(), Float.valueOf(0.15f));
        if (this.type != FDBushType.CROSS) {
            builder.accept(this.getBush().asItem(), Float.valueOf(0.65f));
        }
    }

    @Override
    public void registerConfigs(BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
        BlockState state = (BlockState)this.getBush().defaultBlockState().setValue((Property)BaseBushBlock.AGE, (Comparable)Integer.valueOf(4));
        FeatureUtils.register(ctx, this.configKey, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)state)), List.of(Blocks.GRASS_BLOCK), (int)20));
    }

    @Override
    public void registerPlacements(BootstrapContext<PlacedFeature> ctx) {
        ctx.register(this.placementKey, (Object)new PlacedFeature((Holder)ctx.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(this.configKey), List.of(RarityFilter.onAverageOnceEvery((int)this.rarity), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome())));
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ResourceKey<PlacedFeature> getPlacementKey() {
        return this.placementKey;
    }

    @Override
    public void genRecipe(RegistrateRecipeProvider pvd) {
        if (this.mid != null) {
            pvd.singleItem(DataIngredient.items((ItemLike)((Item)this.mid.get()), (ItemLike[])new Item[0]), RecipeCategory.MISC, this.seedItem, 1, 1);
        }
    }

    public void buildLoot(RegistrateBlockLootTables pvd, BushBlock block) {
        LootPool.Builder pool;
        LootHelper helper = new LootHelper(pvd);
        LootTable.Builder table = LootTable.lootTable();
        if (this.type != FDBushType.CROSS) {
            pool = LootPool.lootPool().add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)this.getBush().asItem()).when(helper.silk())).when(helper.intRangeState((Block)block, (Property)FruitBushBlock.AGE, 2, 4))).when(ExplosionCondition.survivesExplosion());
            table.withPool(pool);
        }
        pool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)this.getFruit()).when(helper.intState((Block)block, (Property)FruitBushBlock.AGE, 4))).apply(helper.fortuneCount(1))).when(ExplosionCondition.survivesExplosion());
        if (this.type == FDBushType.TALL) {
            pool.when(helper.enumState((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        }
        table.withPool(pool);
        pvd.add((Block)block, table);
    }

    public BushBlock getBush() {
        return (BushBlock)this.bush.get();
    }

    @Override
    public Item getFruit() {
        return this.type == FDBushType.TALL ? (Item)this.mid.get() : (Item)this.seedItem.get();
    }

    public Item getSeed() {
        return (Item)this.seedItem.get();
    }

    private static FoodProperties food(int food, float sat, boolean fast) {
        FoodProperties.Builder ans = new FoodProperties.Builder().nutrition(food).saturationModifier(sat);
        if (fast) {
            ans.fast();
        }
        return ans.build();
    }

    public static void register() {
    }
}

