/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.util.StringRepresentable;

public enum ContentsFilterType implements StringRepresentable
{
    ALLOW("allow"),
    BLOCK("block"),
    STORAGE("storage");

    private final String name;
    private static final Map<String, ContentsFilterType> NAME_VALUES;
    private static final ContentsFilterType[] VALUES;

    private ContentsFilterType(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public ContentsFilterType next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static ContentsFilterType fromName(String name) {
        return NAME_VALUES.getOrDefault(name, BLOCK);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ContentsFilterType value : ContentsFilterType.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = ContentsFilterType.values();
    }
}

