/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.feeding;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum HungerLevel implements StringRepresentable
{
    ANY("any"),
    HALF("half"),
    FULL("full");

    public static final Codec<HungerLevel> CODEC;
    public static final StreamCodec<FriendlyByteBuf, HungerLevel> STREAM_CODEC;
    private final String name;
    private static final Map<String, HungerLevel> NAME_VALUES;
    private static final HungerLevel[] VALUES;

    private HungerLevel(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public HungerLevel next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static HungerLevel fromName(String name) {
        return NAME_VALUES.getOrDefault(name, HALF);
    }

    static {
        CODEC = StringRepresentable.fromEnum(HungerLevel::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(HungerLevel.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (HungerLevel value : HungerLevel.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = HungerLevel.values();
    }
}

