/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.entity.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.beachparty.core.block.SandBucketBlock;
import net.satisfy.beachparty.core.util.SandCastleManager;

public class ApproachSandCastleGoal
extends Goal {
    private final Mob mob;
    private BlockPos targetPos;
    private int cooldown;
    private int recalculateCooldown;
    private boolean isMoving;

    public ApproachSandCastleGoal(Mob mob) {
        this.mob = mob;
        this.cooldown = 0;
        this.recalculateCooldown = 0;
        this.isMoving = false;
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = 60;
        if (this.recalculateCooldown > 0) {
            --this.recalculateCooldown;
        } else {
            this.recalculateCooldown = 200;
            BlockPos mobPos = this.mob.blockPosition();
            BlockPos newTargetPos = SandCastleManager.getNearestSandCastle(mobPos);
            if (newTargetPos == null || newTargetPos.equals((Object)this.targetPos)) {
                return false;
            }
            this.targetPos = newTargetPos;
            this.isMoving = false;
        }
        return this.targetPos != null;
    }

    public void start() {
        if (this.targetPos != null) {
            this.moveToTarget();
        }
    }

    private void moveToTarget() {
        this.mob.getNavigation().moveTo((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY(), (double)this.targetPos.getZ() + 0.5, 1.0);
        this.isMoving = true;
    }

    public boolean canContinueToUse() {
        if (this.targetPos == null) {
            return false;
        }
        Level level = this.mob.level();
        BlockState state = level.getBlockState(this.targetPos);
        if (!(state.getBlock() instanceof SandBucketBlock.SandCastleBlock)) {
            return false;
        }
        double distanceSquared = this.mob.distanceToSqr((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY(), (double)this.targetPos.getZ() + 0.5);
        return distanceSquared <= 16.0;
    }

    public void tick() {
        if (this.targetPos == null) {
            return;
        }
        Level level = this.mob.level();
        BlockState state = level.getBlockState(this.targetPos);
        if (!(state.getBlock() instanceof SandBucketBlock.SandCastleBlock)) {
            this.stop();
            return;
        }
        double distanceSquared = this.mob.distanceToSqr((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY(), (double)this.targetPos.getZ() + 0.5);
        if (distanceSquared > 2.25) {
            if (!this.isMoving) {
                this.moveToTarget();
            }
        } else {
            this.isMoving = false;
        }
    }

    public void stop() {
        this.targetPos = null;
        this.isMoving = false;
    }
}

