/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.item;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.satisfy.beachparty.core.entity.BeachBallEntity;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class BeachBallItem
extends Item {
    public BeachBallItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        Direction direction = pContext.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = pContext.getLevel();
        BlockPlaceContext blockplacecontext = new BlockPlaceContext(pContext);
        BlockPos blockpos = blockplacecontext.getClickedPos();
        ItemStack itemstack = pContext.getItemInHand();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockpos);
        AABB aabb = ((EntityType)EntityTypeRegistry.BEACH_BALL.get()).getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
        if (level.noCollision(null, aabb) && level.getEntities(null, aabb).isEmpty() && !level.getBlockState(blockpos.below()).isAir()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverlevel, (ItemStack)itemstack, (Player)pContext.getPlayer());
                BeachBallEntity pells = (BeachBallEntity)((EntityType)EntityTypeRegistry.BEACH_BALL.get()).create(serverlevel, consumer, blockpos, MobSpawnType.SPAWN_EGG, true, true);
                if (pells == null) {
                    return InteractionResult.FAIL;
                }
                float f = (float)Mth.floor((float)((Mth.wrapDegrees((float)(pContext.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                pells.moveTo(pells.getX(), pells.getY(), pells.getZ(), f, 0.0f);
                serverlevel.addFreshEntityWithPassengers((Entity)pells);
                level.playSound(null, pells.getX(), pells.getY(), pells.getZ(), SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 0.35f, 0.9f);
                pells.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)pContext.getPlayer());
            }
            itemstack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.FAIL;
    }
}

