/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.util.LegacyUtils;

public class EffectOperation
implements Operation<LivingEntity, MobEffectInstance> {
    private final Holder<MobEffect> effect;

    private EffectOperation(Holder<MobEffect> effect) {
        this.effect = effect;
    }

    public static void register() {
        BuiltinPrototypes.LIVING_ENTITY.registerOperation(SkillsMod.createIdentifier("get_effect"), BuiltinPrototypes.STATUS_EFFECT_INSTANCE, EffectOperation::parse);
        LegacyBuiltinPrototypes.registerAlias(BuiltinPrototypes.LIVING_ENTITY, SkillsMod.createIdentifier("effect"), SkillsMod.createIdentifier("get_effect"));
    }

    public static Result<EffectOperation, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(EffectOperation::parse, context));
    }

    public static Result<EffectOperation, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<Holder> optEffect = rootObject.get("effect").andThen(BuiltinJson::parseEffect).ifFailure(problems::add).getSuccess().map(arg_0 -> ((Registry)BuiltInRegistries.MOB_EFFECT).wrapAsHolder(arg_0));
        if (problems.isEmpty()) {
            return Result.success(new EffectOperation((Holder<MobEffect>)optEffect.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<MobEffectInstance> apply(LivingEntity entity) {
        return Optional.ofNullable(entity.getEffect(this.effect));
    }
}

