/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ExperienceCurve {
    private final Function<Integer, Integer> function;
    private final int levelLimit;
    private final List<Integer> requiredCache = new ArrayList<Integer>();
    private final List<Integer> requiredTotalCache = new ArrayList<Integer>();

    private ExperienceCurve(Function<Integer, Integer> function, int levelLimit) {
        this.function = function;
        this.levelLimit = levelLimit;
    }

    public static ExperienceCurve create(Function<Integer, Integer> function, int levelLimit) {
        ExperienceCurve curve = new ExperienceCurve(function, levelLimit);
        curve.requiredTotalCache.add(curve.getRequired(0));
        return curve;
    }

    public int getRequired(int level) {
        if (level >= this.levelLimit) {
            return 0;
        }
        while (level >= this.requiredCache.size()) {
            this.requiredCache.add(this.function.apply(this.requiredCache.size()));
        }
        return this.requiredCache.get(level);
    }

    public int getRequiredTotal(int level) {
        level = Math.min(level, this.levelLimit - 1);
        while (level >= this.requiredTotalCache.size()) {
            this.requiredTotalCache.add(this.requiredTotalCache.get(this.requiredTotalCache.size() - 1) + this.getRequired(this.requiredTotalCache.size()));
        }
        return this.requiredTotalCache.get(level);
    }

    public Progress getProgress(int earned) {
        int low = 0;
        int high = this.requiredTotalCache.size();
        while (low < high) {
            int mid = low + high >>> 1;
            if (earned < this.requiredTotalCache.get(mid)) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        int level = low;
        if (level == 0) {
            Integer next = this.requiredTotalCache.get(level);
            return new Progress(level, earned, next);
        }
        if (level < this.requiredTotalCache.size()) {
            Integer prev = this.requiredTotalCache.get(level - 1);
            Integer next = this.requiredTotalCache.get(level);
            return new Progress(level, earned - prev, next - prev);
        }
        while (level < this.levelLimit) {
            Integer prev = this.requiredTotalCache.get(level - 1);
            int next = prev + this.getRequired(level);
            this.requiredTotalCache.add(next);
            if (earned < next) {
                return new Progress(level, earned - prev, next - prev);
            }
            ++level;
        }
        return new Progress(this.levelLimit, 0, 0);
    }

    public int getLevelLimit() {
        return this.levelLimit;
    }

    public record Progress(int currentLevel, int currentExperience, int requiredExperience) {
    }
}

