/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.seeddelight.registry;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.hiedacamellia.seeddelight.item.FoodList;
import org.hiedacamellia.seeddelight.registry.BlockRegistry;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.item.DrinkableItem;

public class ItemRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"seeddelight");
    public static LinkedHashSet<DeferredItem<Item>> CREATIVE_TAB_ITEMS = Sets.newLinkedHashSet();
    public static final DeferredItem<Item> Acorn = ItemRegistry.registerWithTab("acorn", () -> new ConsumableItem(ItemRegistry.basicItem()));
    public static final DeferredItem<Item> AcornKernel = ItemRegistry.registerWithTab("acorn_kernel", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.AcornKernel.get())));
    public static final DeferredItem<Item> Pinecone = ItemRegistry.registerWithTab("pinecone", () -> new ConsumableItem(ItemRegistry.basicItem()));
    public static final DeferredItem<Item> PineNutKernel = ItemRegistry.registerWithTab("pine_nut_kernel", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.PineNutKernel.get())));
    public static final DeferredItem<Item> SunflowerSeed = ItemRegistry.registerWithTab("sunflower_seed", () -> new ConsumableItem(ItemRegistry.basicItem()));
    public static final DeferredItem<Item> FriedSunflowerSeed = ItemRegistry.registerWithTab("fried_sunflower_seed", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.FriedSunflowerSeed.get())));
    public static final DeferredItem<Item> DriedWatermelonSeed = ItemRegistry.registerWithTab("dried_watermelon_seed", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.DriedWatermelonSeed.get())));
    public static final DeferredItem<Item> DriedPumpkinSeed = ItemRegistry.registerWithTab("dried_pumpkin_seed", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.DriedPumpkinSeed.get())));
    public static final DeferredItem<Item> Rosehip = ItemRegistry.registerWithTab("rosehip", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.Rosehip.get())));
    public static final DeferredItem<Item> Cherry = ItemRegistry.registerWithTab("cherry", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.Cherry.get())));
    public static final DeferredItem<Item> RawAcornNoodle = ItemRegistry.registerWithTab("raw_acorn_noodle", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.RawAcornNoodle.get())));
    public static final DeferredItem<Item> CherryJamJar = ItemRegistry.registerWithTab("cherry_jam_jar", () -> new ConsumableItem(ItemRegistry.basicItem().craftRemainder(Items.GLASS_BOTTLE)));
    public static final DeferredItem<Item> RosehipJamJar = ItemRegistry.registerWithTab("rosehip_jam_jar", () -> new ConsumableItem(ItemRegistry.basicItem().craftRemainder(Items.GLASS_BOTTLE)));
    public static final DeferredItem<Item> RosehipTea = ItemRegistry.registerWithTab("rosehip_tea", () -> new DrinkableItem(ItemRegistry.drinkItem().food(FoodList.RosehipTea.get()), true, false));
    public static final DeferredItem<Item> CherryWine = ItemRegistry.registerWithTab("cherry_wine", () -> new DrinkableItem(ItemRegistry.drinkItem().food(FoodList.CherryWine.get()), true, false));
    public static final DeferredItem<Item> PineNeedleWine = ItemRegistry.registerWithTab("pine_needle_wine", () -> new DrinkableItem(ItemRegistry.drinkItem().food(FoodList.PineNeedleWine.get()), true, false));
    public static final DeferredItem<Item> RosehipJamSandwich = ItemRegistry.registerWithTab("rosehip_jam_sandwich", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.RosehipJamSandwich.get())));
    public static final DeferredItem<Item> CherryJamSandwich = ItemRegistry.registerWithTab("cherry_jam_sandwich", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.CherryJamSandwich.get())));
    public static final DeferredItem<Item> SunflowerSeedCrisp = ItemRegistry.registerWithTab("sunflower_seed_crisp", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.SunflowerSeedCrisp.get())));
    public static final DeferredItem<Item> SunflowerSeedToast = ItemRegistry.registerWithTab("sunflower_seed_toast", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.SunflowerSeedToast.get())));
    public static final DeferredItem<Item> SeedRosehipPie = ItemRegistry.registerWithTab("seed_rosehip_pie", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.SeedRosehipPie.get())));
    public static final DeferredItem<Item> RoastedBeefWithSeed = ItemRegistry.registerWithTab("roasted_beef_with_seed", () -> new ConsumableItem(ItemRegistry.bowlFoodItem(FoodList.RoastedBeefWithSeed.get())));
    public static final DeferredItem<Item> AcornTofu = ItemRegistry.registerWithTab("acorn_tofu", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.AcornTofu.get())));
    public static final DeferredItem<Item> StirFriedCabbageWithAcorn = ItemRegistry.registerWithTab("stir_fried_cabbage_with_acorn", () -> new ConsumableItem(ItemRegistry.bowlFoodItem(FoodList.StirFriedCabbageWithAcorn.get())));
    public static final DeferredItem<Item> AcornBread = ItemRegistry.registerWithTab("acorn_bread", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.AcornBread.get())));
    public static final DeferredItem<Item> PinenutGruel = ItemRegistry.registerWithTab("pinenut_gruel", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.PinenutGruel.get())));
    public static final DeferredItem<Item> PinenutCake = ItemRegistry.registerWithTab("pinenut_cake", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.PinenutCake.get())));
    public static final DeferredItem<Item> SeedTart = ItemRegistry.registerWithTab("seed_tart", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.SeedTart.get())));
    public static final DeferredItem<Item> PinenutWithMeatballs = ItemRegistry.registerWithTab("pinenut_with_meatballs", () -> new ConsumableItem(ItemRegistry.bowlFoodItem(FoodList.PinenutWithMeatballs.get())));
    public static final DeferredItem<Item> RoseCookie = ItemRegistry.registerWithTab("rose_cookie", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.RoseCookie.get())));
    public static final DeferredItem<Item> RosehipCake = ItemRegistry.registerWithTab("rosehip_cake", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.RosehipCake.get())));
    public static final DeferredItem<Item> CherryIceCream = ItemRegistry.registerWithTab("cherry_ice_cream", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.CherryIceCream.get())));
    public static final DeferredItem<Item> CherryPork = ItemRegistry.registerWithTab("cherry_pork", () -> new ConsumableItem(ItemRegistry.bowlFoodItem(FoodList.CherryPork.get())));
    public static final DeferredItem<Item> MilkCherryMouss = ItemRegistry.registerWithTab("milk_cherry_mouss", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.MilkCherryMouss.get())));
    public static final DeferredItem<Item> RosehipPie = ItemRegistry.registerWithTab("rosehip_pie", () -> new BlockItem((Block)BlockRegistry.RosehipPie.get(), ItemRegistry.basicItem()));
    public static final DeferredItem<Item> RosehipPieSlice = ItemRegistry.registerWithTab("rosehip_pie_slice", () -> new ConsumableItem(ItemRegistry.foodItem(FoodList.RosehipPieSlice.get())));
    public static final DeferredItem<Item> AcornBag = ItemRegistry.registerWithTab("acorn_bag", () -> new BlockItem((Block)BlockRegistry.AcornBag.get(), ItemRegistry.basicItem()));
    public static final DeferredItem<Item> PineconeBag = ItemRegistry.registerWithTab("pinecone_bag", () -> new BlockItem((Block)BlockRegistry.PineconeBag.get(), ItemRegistry.basicItem()));
    public static final DeferredItem<Item> CherryCrate = ItemRegistry.registerWithTab("cherry_crate", () -> new BlockItem((Block)BlockRegistry.CherryCrate.get(), ItemRegistry.basicItem()));
    public static final DeferredItem<Item> RosehipCrate = ItemRegistry.registerWithTab("rosehip_crate", () -> new BlockItem((Block)BlockRegistry.RosehipCrate.get(), ItemRegistry.basicItem()));

    public static DeferredItem<Item> registerWithTab(String name, Supplier<Item> supplier) {
        DeferredItem block = ITEMS.register(name, supplier);
        CREATIVE_TAB_ITEMS.add((DeferredItem<Item>)block);
        return block;
    }

    public static Item.Properties basicItem() {
        return new Item.Properties();
    }

    public static Item.Properties foodItem(FoodProperties food) {
        return new Item.Properties().food(food);
    }

    public static Item.Properties bowlFoodItem(FoodProperties food) {
        return new Item.Properties().food(food).craftRemainder(Items.BOWL).stacksTo(16);
    }

    public static Item.Properties drinkItem() {
        return new Item.Properties().craftRemainder(Items.GLASS_BOTTLE).stacksTo(16);
    }
}

