/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.blockEntity.behaviour;

import com.oierbravo.mechanicals.foundation.recipe.IRecipeWithRequirements;
import com.oierbravo.mechanicals.utility.LibLang;
import com.oierbravo.mechanicals.utility.MechanicalLangIdGenerator;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RecipeRequirementsBehaviour<R extends IRecipeWithRequirements>
extends BlockEntityBehaviour {
    public static final BehaviourType<RecipeRequirementsBehaviour<?>> TYPE = new BehaviourType();
    public RecipeRequirementsSpecifics<R> specifics;
    private ArrayList<String> missingRequirements;

    public <T extends SmartBlockEntity> RecipeRequirementsBehaviour(T te) {
        super(te);
        this.specifics = (RecipeRequirementsSpecifics)te;
        this.missingRequirements = new ArrayList();
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean meetsRequirements() {
        return !this.missingRequirements.isEmpty();
    }

    public boolean checkRequirements(R pRecipe) {
        this.missingRequirements = new ArrayList();
        if (!this.specifics.matchesIngredients(pRecipe)) {
            this.missingRequirements.add("ingredients");
            this.blockEntity.sendData();
            return false;
        }
        if (!this.specifics.hasEnoughOutputSpace(pRecipe)) {
            this.missingRequirements.add("output");
        }
        this.missingRequirements.addAll(pRecipe.getMissingRequirements((BlockEntity)this.specifics));
        if (!this.missingRequirements.isEmpty()) {
            this.blockEntity.sendData();
            return false;
        }
        this.blockEntity.sendData();
        return true;
    }

    public void cleanRequirements() {
        this.missingRequirements.clear();
        this.blockEntity.sendData();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, boolean added) {
        if (this.missingRequirements.isEmpty()) {
            return false;
        }
        for (String requirementId : this.missingRequirements) {
            LibLang.translate(MechanicalLangIdGenerator.recipeRequirement(requirementId, "missing"), new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
            added = true;
        }
        return added;
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        ListTag missingRequirementsTag = new ListTag();
        for (String missingId : this.missingRequirements) {
            CompoundTag tag = new CompoundTag();
            tag.putString("t", missingId);
            missingRequirementsTag.add((Object)tag);
        }
        compound.put("MissingRequirements", (Tag)missingRequirementsTag);
        super.write(compound, registries, clientPacket);
    }

    public void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.missingRequirements = new ArrayList();
        ListTag missingRequirementsTag = compound.getList("MissingRequirements", 10);
        for (Tag tag : missingRequirementsTag) {
            CompoundTag requirementsTag = (CompoundTag)tag;
            this.missingRequirements.add(requirementsTag.getString("t"));
        }
        super.read(compound, registries, clientPacket);
    }

    public static interface RecipeRequirementsSpecifics<R extends IRecipeWithRequirements> {
        public boolean hasEnoughOutputSpace(R var1);

        public boolean matchesIngredients(R var1);
    }
}

