/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WingsArgument
implements ArgumentType<FlightApparatusImpl> {
    public static final String KEY_WINGS_NOT_FOUND = "wings.wingsNotFound";
    private static final Collection<String> EXAMPLES = Stream.of(FlightApparatusImpl.ANGEL, FlightApparatusImpl.DRAGON).map(FlightApparatusImpl::id).toList();
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_WING = new DynamicCommandExceptionType(component -> Component.translatable((String)KEY_WINGS_NOT_FOUND, (Object[])new Object[]{component}));
    private static final KeyedValueProvider<FlightApparatusImpl> VALUE_PROVIDER = KeyedValueProvider.enumConstants(FlightApparatusImpl.class, (String)"fantasticwings");

    private WingsArgument() {
    }

    public static WingsArgument wings() {
        return new WingsArgument();
    }

    public static FlightApparatusImpl getWings(CommandContext<CommandSourceStack> ctx, String value) throws CommandSyntaxException {
        return (FlightApparatusImpl)ctx.getArgument(value, FlightApparatusImpl.class);
    }

    public FlightApparatusImpl parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation key = ResourceLocation.read((StringReader)reader);
        return (FlightApparatusImpl)VALUE_PROVIDER.getValue(key).orElseThrow(() -> ERROR_UNKNOWN_WING.create((Object)key));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggestResource(VALUE_PROVIDER.stream().map(Map.Entry::getKey).toList(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

