/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight;

import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.network.ServerboundControlFlyingMessage;
import fuzs.fantasticwings.util.CubicBezier;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class FlightCapability
extends CapabilityComponent<Player> {
    private static final String KEY_IS_FLYING = FantasticWings.id("is_flying").toString();
    private static final String KEY_TIME_FLYING = FantasticWings.id("time_flying").toString();
    private static final String KEY_WING_TYPE = FantasticWings.id("wing_type").toString();
    private static final CubicBezier FLY_AMOUNT_CURVE = new CubicBezier(0.37f, 0.13f, 0.3f, 1.12f);
    private static final int INITIAL_TIME_FLYING = 0;
    private static final int MAX_TIME_FLYING = 20;
    private static final float MIN_SPEED = 0.03f;
    private static final float MAX_SPEED = 0.0715f;
    private static final float Y_BOOST = 0.05f;
    private static final float MANUAL_Y_BOOST = 0.06f;
    private static final float FALL_REDUCTION = 0.9f;
    private static final float PITCH_OFFSET = 30.0f;
    private int prevTimeFlying = 0;
    private int timeFlying = 0;
    private boolean isFlying;
    private FlightApparatus.FlightApparatusHolder holder = FlightApparatus.FlightApparatusHolder.empty();

    public void setIsFlying(boolean isFlying) {
        this.setIsFlying(isFlying, null);
    }

    public void setIsFlying(boolean isFlying, @Nullable PlayerSet playerSet) {
        if (this.isFlying != isFlying) {
            this.isFlying = isFlying;
            if (this.isFlying) {
                ((Player)this.getHolder()).unRide();
            }
            this.setChanged(playerSet);
        }
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public void toggleIsFlying(PlayerSet playerSet) {
        this.setIsFlying(!this.isFlying, playerSet);
    }

    public void setTimeFlying(int timeFlying) {
        if (this.timeFlying != timeFlying) {
            this.timeFlying = timeFlying;
            this.setChanged(PlayerSet.ofNone());
        }
    }

    public void setWings(FlightApparatus.FlightApparatusHolder flightApparatus) {
        if (!this.holder.is(flightApparatus)) {
            this.holder = flightApparatus;
            this.setChanged();
        }
    }

    public FlightApparatus.FlightApparatusHolder getWings() {
        return this.holder;
    }

    public float getFlyingAmount(float delta) {
        return FLY_AMOUNT_CURVE.eval(MathHelper.lerp(this.prevTimeFlying, this.timeFlying, delta) / 20.0f);
    }

    public boolean canUseWings() {
        return !((Player)this.getHolder()).getAbilities().flying && !((Player)this.getHolder()).getItemBySlot(EquipmentSlot.CHEST).is(ModRegistry.WING_OBSTRUCTIONS);
    }

    public boolean canFly() {
        return this.holder.flightApparatus().isUsableForFlying((Player)this.getHolder()) && this.canUseWings();
    }

    public boolean canSlowlyDescend() {
        return this.holder.flightApparatus().isUsableForSlowlyDescending((Player)this.getHolder()) && this.canUseWings() && (this.isFlying() || !((Player)this.getHolder()).isDescending() && !((Player)this.getHolder()).getAbilities().mayfly);
    }

    private void onWornUpdate() {
        Player player = (Player)this.getHolder();
        if (!player.level().isClientSide && this.isFlying() && !this.canFly()) {
            this.setIsFlying(false);
        }
        if (player.isEffectiveAi()) {
            if (this.isFlying()) {
                float speed = Mth.clampedLerp((float)0.03f, (float)0.0715f, (float)player.zza);
                float elevationBoost = MathHelper.transform(Math.abs(player.getXRot()), 45.0f, 90.0f, 1.0f, 0.0f);
                float pitch = -MathHelper.toRadians(player.getXRot() - 30.0f * elevationBoost);
                float yaw = -MathHelper.toRadians(player.getYRot()) - (float)Math.PI;
                float vxz = -Mth.cos((float)pitch);
                float vy = Mth.sin((float)pitch);
                float vz = Mth.cos((float)yaw);
                float vx = Mth.sin((float)yaw);
                player.setDeltaMovement(player.getDeltaMovement().add((double)(vx * vxz * speed), (double)(vy * speed) + (double)0.05f * (player.getXRot() > 0.0f ? (double)elevationBoost : 1.0), (double)(vz * vxz * speed)));
                if (player.jumping) {
                    player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)0.03f, 0.0));
                } else if (player.isDescending()) {
                    player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)-0.06f, 0.0));
                }
            }
            if (this.canSlowlyDescend()) {
                Vec3 deltaMovement = player.getDeltaMovement();
                if (deltaMovement.y() < 0.0) {
                    player.setDeltaMovement(deltaMovement.multiply(1.0, (double)0.9f, 1.0));
                }
                player.fallDistance = 0.0f;
            }
        }
    }

    public void tick() {
        Player player = (Player)this.getHolder();
        if (!this.holder.isEmpty() || !player.isEffectiveAi()) {
            this.onWornUpdate();
        } else if (!player.level().isClientSide && this.isFlying()) {
            this.setIsFlying(false);
        }
        this.prevTimeFlying = this.timeFlying;
        if (this.isFlying()) {
            if (this.timeFlying < 20) {
                this.setTimeFlying(this.timeFlying + 1);
            } else if (player.isLocalPlayer() && player.onGround()) {
                this.setIsFlying(false, PlayerSet.ofNone());
                FantasticWings.NETWORK.sendMessage((ServerboundMessage)new ServerboundControlFlyingMessage(false));
            }
        } else if (this.timeFlying > 0) {
            this.setTimeFlying(this.timeFlying - 1);
        }
    }

    public void onFlown(Vec3 direction) {
        Player player = (Player)this.getHolder();
        if (this.isFlying()) {
            this.holder.flightApparatus().onFlying(player, direction);
        } else if (this.canSlowlyDescend() && player.getDeltaMovement().y() < -0.5) {
            this.holder.flightApparatus().onSlowlyDescending(player, direction);
        }
    }

    public void write(CompoundTag compoundTag, HolderLookup.Provider registries) {
        compoundTag.putBoolean(KEY_IS_FLYING, this.isFlying);
        compoundTag.putInt(KEY_TIME_FLYING, this.timeFlying);
        compoundTag.put(KEY_WING_TYPE, (Tag)this.holder.writeToNbtTag());
    }

    public void read(CompoundTag compoundTag, HolderLookup.Provider registries) {
        this.isFlying = compoundTag.getBoolean(KEY_IS_FLYING);
        this.timeFlying = compoundTag.getInt(KEY_TIME_FLYING);
        this.holder = FlightApparatus.FlightApparatusHolder.readFromNbtTag(compoundTag.getCompound(KEY_WING_TYPE));
    }
}

