/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.nio.file.Path;

public class ModConfig {
    private static final String CONFIG_FILE_NAME = "createfood.toml";
    private static final String ITEM_TEST = "config.item_test";
    private static final String FLUID_TEST = "config.fluid_test";
    private static FileConfig config;

    public static void loadConfig(Path configPath) {
        Path configFilePath = configPath.resolve(CONFIG_FILE_NAME);
        config = FileConfig.builder((Path)configFilePath).sync().autosave().build();
        config.load();
        if (!config.contains(ITEM_TEST)) {
            config.add(ITEM_TEST, (Object)true);
            config.save();
        }
        if (!config.contains(FLUID_TEST)) {
            config.add(FLUID_TEST, (Object)true);
            config.save();
        }
    }

    public static boolean EnableItemTest() {
        return (Boolean)config.getOrElse(ITEM_TEST, (Object)false);
    }

    public static boolean EnableFluidTest() {
        return (Boolean)config.getOrElse(FLUID_TEST, (Object)false);
    }

    public static void setConfig(boolean value) {
        config.set(ITEM_TEST, (Object)value);
        config.set(FLUID_TEST, (Object)value);
        config.save();
    }

    public static void closeConfig() {
        if (config != null) {
            config.close();
        }
    }
}

