/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.item;

import dev.xkmc.fruitsdelight.content.item.FDFoodItem;
import dev.xkmc.fruitsdelight.content.item.IFDFoodItem;
import dev.xkmc.fruitsdelight.init.data.LangData;
import dev.xkmc.fruitsdelight.init.food.FoodType;
import dev.xkmc.fruitsdelight.init.food.IFDFood;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import vectorwing.farmersdelight.common.Configuration;

public class FDBlockItem
extends BlockItem
implements IFDFoodItem {
    public final IFDFood food;
    private final UseAnim anim;

    public FDBlockItem(Block block, Item.Properties properties, IFDFood food) {
        this(block, properties, food, UseAnim.EAT);
    }

    public FDBlockItem(Block block, Item.Properties props, IFDFood food, UseAnim anim) {
        super(block, props);
        this.food = food;
        this.anim = anim;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return this.anim;
    }

    public SoundEvent getDrinkingSound() {
        if (this.food != null && this.food.getType() == FoodType.JAM) {
            return SoundEvents.HONEY_DRINK;
        }
        return SoundEvents.GENERIC_DRINK;
    }

    public InteractionResult place(BlockPlaceContext ctx) {
        if (ctx.getPlayer() != null && !ctx.getPlayer().isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        return super.place(ctx);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity consumer) {
        ItemStack itemStack = this.getCraftingRemainingItem(stack);
        super.finishUsingItem(stack, worldIn, consumer);
        if (itemStack.isEmpty()) {
            return stack;
        }
        if (stack.isEmpty()) {
            return itemStack;
        }
        if (consumer instanceof Player) {
            Player player = (Player)consumer;
            if (!player.getAbilities().instabuild && !player.getInventory().add(itemStack)) {
                player.drop(itemStack, false);
            }
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.TOOLTIP_PLACE.get(new Object[0]));
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            FDFoodItem.getFoodEffects(stack, list);
        }
    }

    @Override
    public IFDFood food() {
        return this.food;
    }
}

