/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.events;

import dev.xkmc.fruitsdelight.content.effects.EffectRemovalEffect;
import dev.xkmc.fruitsdelight.init.registrate.FDEffects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(modid="fruitsdelight", bus=EventBusSubscriber.Bus.GAME)
public class EffectHandlers {
    @SubscribeEvent
    public static void onEntitySize(EntityEvent.Size event) {
        Player le;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (le = (Player)entity).isAddedToLevel() && le.isShiftKeyDown() && le.hasEffect(FDEffects.SHRINKING.holder())) {
            event.setNewSize(event.getNewSize().scale(0.5f));
        }
    }

    @SubscribeEvent
    public static void onEffectEnd(MobEffectEvent.Expired event) {
        MobEffectInstance ins = event.getEffectInstance();
        if (ins == null) {
            return;
        }
        if (ins.getEffect().value() == FDEffects.SHRINKING.get()) {
            event.getEntity().refreshDimensions();
        }
    }

    @SubscribeEvent
    public static void onEffectEnd(MobEffectEvent.Remove event) {
        MobEffectInstance ins = event.getEffectInstance();
        if (ins == null) {
            return;
        }
        if (ins.getEffect().value() == FDEffects.SHRINKING.get()) {
            event.getEntity().refreshDimensions();
        }
    }

    @SubscribeEvent
    public static void onItemStartUse(LivingEntityUseItemEvent.Start event) {
        MobEffectInstance ins = event.getEntity().getEffect(FDEffects.LOZENGE.holder());
        if (ins != null && EffectHandlers.isEatOrDrink(event.getEntity(), event.getItem())) {
            event.setDuration(event.getDuration() >> 1 + ins.getAmplifier());
        }
    }

    @SubscribeEvent
    public static void onEffectTest(MobEffectEvent.Applicable event) {
        MobEffectInstance e = event.getEffectInstance();
        if (e == null) {
            return;
        }
        for (MobEffectInstance old : event.getEntity().getActiveEffects()) {
            Holder holder = old.getEffect();
            if (!(holder instanceof EffectRemovalEffect)) continue;
            EffectRemovalEffect eff = (EffectRemovalEffect)holder;
            if (!((Set)eff.set.get()).contains(e.getEffect())) continue;
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            return;
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        LivingEntity le;
        Projectile proj;
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Projectile && (entity = (proj = (Projectile)entity2).getOwner()) instanceof LivingEntity && (le = (LivingEntity)entity).hasEffect(FDEffects.LEAF_PIERCING.holder())) {
            proj.addTag(FDEffects.LEAF_PIERCING.key().location().toString());
        }
    }

    public static boolean isEatOrDrink(LivingEntity le, ItemStack stack) {
        if (stack.getFoodProperties(le) == null) {
            return true;
        }
        try {
            UseAnim anim = stack.getUseAnimation();
            if (anim == UseAnim.EAT || anim == UseAnim.DRINK) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static float getFriction(LivingEntity le, float ans) {
        if (le.hasEffect(FDEffects.ASTRINGENT)) {
            return Math.min(0.6f, ans);
        }
        return ans;
    }

    public static float getBoatFriction(Boat boat, float ans) {
        for (Entity e : boat.getPassengers()) {
            LivingEntity le;
            if (!(e instanceof LivingEntity) || !(le = (LivingEntity)e).hasEffect(FDEffects.SLIDING)) continue;
            return Math.max(0.98f, ans);
        }
        return ans;
    }
}

