/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.data;

import dev.xkmc.fruitsdelight.compat.biomes.ModBiomeKeys;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.FDBushes;
import dev.xkmc.fruitsdelight.init.plants.FDMelons;
import dev.xkmc.fruitsdelight.init.plants.FDPineapple;
import dev.xkmc.fruitsdelight.init.plants.FDTrees;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public final class FDBiomeTagsProvider
extends BiomeTagsProvider {
    public FDBiomeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> pvd, ExistingFileHelper helper) {
        super(output, pvd, "fruitsdelight", helper);
    }

    protected void addTags(HolderLookup.Provider pvd) {
        TagKey<Biome> plain = FDBiomeTagsProvider.asTag("vanilla/plains");
        TagKey<Biome> birch = FDBiomeTagsProvider.asTag("vanilla/birch");
        TagKey<Biome> taiga = FDBiomeTagsProvider.asTag("vanilla/taiga");
        TagKey<Biome> taiga_cold = FDBiomeTagsProvider.asTag("vanilla/taiga_cold");
        TagKey<Biome> swamp = FDBiomeTagsProvider.asTag("vanilla/swamp");
        TagKey<Biome> oak = FDBiomeTagsProvider.asTag("vanilla/fruitful_forest");
        TagKey<Biome> tropical = FDBiomeTagsProvider.asTag("vanilla/tropical");
        TagKey<Biome> windswpet = FDBiomeTagsProvider.asTag("vanilla/windswept");
        this.tag(plain).add(new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.MEADOW});
        this.tag(birch).add(new ResourceKey[]{Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST});
        this.tag(taiga).add(new ResourceKey[]{Biomes.TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.OLD_GROWTH_PINE_TAIGA});
        this.tag(taiga_cold).add(new ResourceKey[]{Biomes.SNOWY_TAIGA, Biomes.GROVE, Biomes.SNOWY_PLAINS});
        this.tag(swamp).add(new ResourceKey[]{Biomes.SWAMP, Biomes.MANGROVE_SWAMP});
        this.tag(oak).add(new ResourceKey[]{Biomes.FOREST, Biomes.FLOWER_FOREST});
        this.tag(tropical).add(new ResourceKey[]{Biomes.JUNGLE, Biomes.BAMBOO_JUNGLE});
        this.tag(windswpet).add(new ResourceKey[]{Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.ORANGE)).addTags(new TagKey[]{ModBiomeKeys.WARM.asTag(), oak});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.APPLE)).addTags(new TagKey[]{ModBiomeKeys.WARM.asTag(), oak});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.KIWI)).addTags(new TagKey[]{ModBiomeKeys.WARM.asTag(), oak});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.FIG)).addTags(new TagKey[]{ModBiomeKeys.WARM.asTag(), oak});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.LYCHEE)).addTags(new TagKey[]{ModBiomeKeys.HOT_HUMID.asTag(), tropical});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.MANGO)).addTags(new TagKey[]{ModBiomeKeys.HOT_HUMID.asTag(), tropical});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.BAYBERRY)).addTags(new TagKey[]{ModBiomeKeys.HOT_HUMID.asTag(), swamp});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.MANGOSTEEN)).addTags(new TagKey[]{ModBiomeKeys.HOT_HUMID.asTag(), swamp, tropical});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.HAWBERRY)).addTags(new TagKey[]{ModBiomeKeys.COLD.asTag(), taiga});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.PERSIMMON)).addTags(new TagKey[]{ModBiomeKeys.COLD.asTag(), taiga_cold});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.PEAR)).addTags(new TagKey[]{ModBiomeKeys.WARM.asTag(), birch});
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.PEACH)).addTag(ModBiomeKeys.HOT_HUMID.asTag()).add(Biomes.SPARSE_JUNGLE);
        this.tag(FDBiomeTagsProvider.asTag(FDTrees.DURIAN)).addTags(new TagKey[]{ModBiomeKeys.HOT_HUMID.asTag(), swamp, tropical}).add(Biomes.SPARSE_JUNGLE);
        this.tag(FDBiomeTagsProvider.asTag(FDBushes.LEMON)).addTags(new TagKey[]{ModBiomeKeys.WARM.asTag(), plain});
        this.tag(FDBiomeTagsProvider.asTag(FDBushes.CRANBERRY)).addTags(new TagKey[]{ModBiomeKeys.HOT_HUMID.asTag(), swamp, tropical}).add(Biomes.DARK_FOREST);
        this.tag(FDBiomeTagsProvider.asTag(FDBushes.BLUEBERRY)).addTags(new TagKey[]{ModBiomeKeys.COLD.asTag(), taiga, taiga_cold, swamp, windswpet});
        this.tag(FDBiomeTagsProvider.asTag(FDMelons.HAMIMELON)).addTag(ModBiomeKeys.DESERT.asTag()).add(Biomes.DESERT);
        this.tag(FDBiomeTagsProvider.asTag(FDPineapple.PINEAPPLE)).addTag(ModBiomeKeys.BEACH.asTag()).add(Biomes.BEACH);
        ModBiomeKeys.generate(x$0 -> this.tag((TagKey)x$0));
    }

    public static TagKey<Biome> asTag(PlantDataEntry<?> plant) {
        return FDBiomeTagsProvider.asTag("plants/" + plant.getName() + "_biomes");
    }

    public static TagKey<Biome> asTag(String name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)FruitsDelight.loc(name));
    }
}

