/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.food;

import dev.xkmc.fruitsdelight.content.item.DurianFleshItem;
import dev.xkmc.fruitsdelight.content.item.FDBlockItem;
import dev.xkmc.fruitsdelight.content.item.FDFoodItem;
import dev.xkmc.fruitsdelight.init.food.IFDFood;
import dev.xkmc.fruitsdelight.init.food.IFoodFactory;
import java.util.function.Supplier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public enum FoodClass {
    NONE((b, p, e) -> new FDFoodItem(p, e), null),
    STICK((b, p, e) -> new FDFoodItem(p, e), () -> Items.STICK),
    GLASS((b, p, e) -> new FDFoodItem(p.stacksTo(16), e, UseAnim.DRINK), () -> Items.GLASS_BOTTLE),
    JAM((b, p, e) -> new FDBlockItem(b, p.stacksTo(16), e, UseAnim.DRINK), () -> Items.GLASS_BOTTLE),
    BOWL((b, p, e) -> new FDFoodItem(p.stacksTo(16), e), () -> Items.BOWL),
    DURIAN_FLESH((b, p, e) -> new DurianFleshItem(p, e), null),
    PLATE((b, p, e) -> new FDBlockItem(b, p.stacksTo(16), e), () -> Items.BOWL);

    public final IFoodFactory factory;
    private final Supplier<Item> container;

    private FoodClass(IFoodFactory factory, Supplier<Item> container) {
        this.factory = factory;
        this.container = container;
    }

    public Item build(@Nullable Block block, Item.Properties food, IFDFood type, FoodProperties.Builder builder) {
        if (this.container != null) {
            Item item = this.container.get();
            builder = builder.usingConvertsTo((ItemLike)item);
            food.craftRemainder(item);
        }
        food.food(builder.build());
        return this.factory.build(block, food, type);
    }
}

