/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.fruitsdelight.content.block.BaseBushBlock;
import dev.xkmc.fruitsdelight.content.block.PineappleBlock;
import dev.xkmc.fruitsdelight.content.block.WildPineappleBlock;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import dev.xkmc.l2core.serial.loot.LootHelper;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public enum FDPineapple implements PlantDataEntry<FDPineapple>
{
    PINEAPPLE(2, 0.3f, true);

    private final BlockEntry<PineappleBlock> PLANT;
    private final BlockEntry<WildPineappleBlock> WILD;
    private final ItemEntry<Item> fruit;
    private final ItemEntry<Item> slice;
    private final ItemEntry<ItemNameBlockItem> seed;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKey;
    public final ResourceKey<PlacedFeature> placementKey;

    private FDPineapple(int food, float sat, boolean fast) {
        String name = this.name().toLowerCase(Locale.ROOT);
        this.configKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)FruitsDelight.loc(name));
        this.placementKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)FruitsDelight.loc(name));
        this.PLANT = FruitsDelight.REGISTRATE.block(name, p -> new PineappleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT))).blockstate(this::buildPlantModel).loot(this::buildPlantLoot).register();
        this.WILD = ((BlockBuilder)FruitsDelight.REGISTRATE.block("wild_" + name, p -> new WildPineappleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS))).blockstate(this::buildWildModel).loot(this::buildWildLoot).item().model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/" + name + "_wild")})).build()).register();
        this.fruit = ((ItemBuilder)FruitsDelight.REGISTRATE.item(name, Item::new).transform(b -> PlantDataEntry.addFruitTags(name, b))).register();
        this.slice = FruitsDelight.REGISTRATE.item(name + "_slice", p -> new Item(p.food(FDPineapple.food(food, sat, fast)))).register();
        this.seed = FruitsDelight.REGISTRATE.item(name + "_sapling", p -> new ItemNameBlockItem((Block)this.getPlant(), p)).register();
    }

    private void buildPlantModel(DataGenContext<Block, PineappleBlock> ctx, RegistrateBlockstateProvider pvd) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)PineappleBlock.AGE);
            String tex = this.getName() + "_stage_" + age;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)pvd.models().cross(tex, pvd.modLoc("block/" + tex))).renderType("cutout")).build();
        });
    }

    private void buildWildModel(DataGenContext<Block, WildPineappleBlock> ctx, RegistrateBlockstateProvider pvd) {
        String tex = this.getName() + "_wild";
        pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)pvd.models().cross(tex, pvd.modLoc("block/" + tex))).renderType("cutout"));
    }

    private void buildPlantLoot(RegistrateBlockLootTables pvd, PineappleBlock block) {
        LootHelper helper = new LootHelper(pvd);
        pvd.add((Block)block, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)this.getWholeFruit()).when(helper.intState((Block)block, (Property)PineappleBlock.AGE, 4))).otherwise((LootPoolEntryContainer.Builder)pvd.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)this.getSapling()))))));
    }

    private void buildWildLoot(RegistrateBlockLootTables pvd, WildPineappleBlock block) {
        LootHelper helper = new LootHelper(pvd);
        pvd.add((Block)block, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block.asItem()).when(helper.silk())).otherwise((LootPoolEntryContainer.Builder)pvd.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)this.getWholeFruit()))))));
    }

    @Override
    public void genRecipe(RegistrateRecipeProvider pvd) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{this.getWholeFruit()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)this.getSlice(), (int)6, (int)1).addResult((ItemLike)this.getSapling()).addResultWithChance((ItemLike)this.getSapling(), 0.5f).build((RecipeOutput)pvd, FruitsDelight.loc(this.getName() + "_cutting"));
    }

    public BaseBushBlock getPlant() {
        return (BaseBushBlock)((Object)this.PLANT.get());
    }

    public Block getWildPlant() {
        return (Block)this.WILD.get();
    }

    public Item getWholeFruit() {
        return (Item)this.fruit.get();
    }

    public Item getSlice() {
        return (Item)this.slice.get();
    }

    public Item getSapling() {
        return (Item)this.seed.get();
    }

    @Override
    public void registerComposter(BiConsumer<Item, Float> builder) {
        builder.accept(this.getSapling(), Float.valueOf(0.3f));
        builder.accept(this.getSlice(), Float.valueOf(0.5f));
        builder.accept(this.getWholeFruit(), Float.valueOf(0.65f));
        builder.accept(this.getWildPlant().asItem(), Float.valueOf(0.65f));
    }

    @Override
    public void registerConfigs(BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
        FeatureUtils.register(ctx, this.configKey, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)new RandomPatchConfiguration(24, 5, 3, PlacementUtils.filtered((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)this.getWildPlant())), (BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.replaceable(), BlockPredicate.noFluid(), BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.SAND})}))));
    }

    @Override
    public void registerPlacements(BootstrapContext<PlacedFeature> ctx) {
        PlacementUtils.register(ctx, this.placementKey, (Holder)ctx.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(this.configKey), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ResourceKey<PlacedFeature> getPlacementKey() {
        return this.placementKey;
    }

    private static FoodProperties food(int food, float sat, boolean fast) {
        FoodProperties.Builder ans = new FoodProperties.Builder().nutrition(food).saturationModifier(sat);
        if (fast) {
            ans.fast();
        }
        return ans.build();
    }

    public static void register() {
    }
}

