/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ConfiguredSameTags {
    private static final Map<TagKey<Block>, Set<Holder<Block>>> TAGS = new HashMap<TagKey<Block>, Set<Holder<Block>>>();

    public static void refreshTags(List<? extends String> tags) {
        Set tagPatterns = tags.stream().map(s -> Pattern.compile("^" + s.replace("*", ".*") + "$")).collect(Collectors.toSet());
        TAGS.clear();
        for (Pattern pattern : tagPatterns) {
            BuiltInRegistries.BLOCK.getTagNames().forEach(tag -> {
                if (tag.location().toString().matches(pattern.pattern())) {
                    Iterable tagOrEmpty = BuiltInRegistries.BLOCK.getTagOrEmpty(tag);
                    HashSet<Holder> blocks = new HashSet<Holder>();
                    for (Holder blockHolder : tagOrEmpty) {
                        blocks.add(blockHolder);
                    }
                    TAGS.put((TagKey<Block>)tag, blocks);
                }
            });
        }
    }

    public static boolean isAllowed(BlockState originalState, BlockState otherState) {
        for (TagKey blockTagKey : originalState.getTags().toList()) {
            if (!TAGS.containsKey(blockTagKey) || !otherState.is(blockTagKey)) continue;
            return true;
        }
        return false;
    }
}

