/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message;

import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.payload.WorldMapMessagePayload;
import xaero.map.message.type.WorldMapMessageType;

public class WorldMapMessagePayloadHandler
implements IPayloadHandler<WorldMapMessagePayload<?>> {
    public void handle(WorldMapMessagePayload<?> payload, IPayloadContext context) {
        this.handleTyped(payload, context);
    }

    private <T extends WorldMapMessage<T>> void handleTyped(WorldMapMessagePayload<T> payload, IPayloadContext context) {
        if (payload == null) {
            return;
        }
        Object message = payload.getMsg();
        WorldMapMessageType type = payload.getType();
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            if (type.getClientHandler() == null) {
                return;
            }
            context.enqueueWork(() -> type.getClientHandler().handle((WorldMapMessage)message));
            return;
        }
        if (type.getServerHandler() == null) {
            return;
        }
        ServerPlayer player = (ServerPlayer)context.player();
        if (player == null) {
            return;
        }
        context.enqueueWork(() -> type.getServerHandler().handle(player.getServer(), player, (WorldMapMessage)message));
    }
}

