/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.block.LineConnectingBlock;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class TableBlock
extends LineConnectingBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty HAS_TABLECLOTH;
    public static final VoxelShape TOP_SHAPE;
    public static final VoxelShape[] LEG_SHAPES;

    public TableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_TABLECLOTH, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (itemStack.getItem().equals(ObjectRegistry.PATTERNED_CARPET.get()) && !((Boolean)state.getValue((Property)HAS_TABLECLOTH)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)HAS_TABLECLOTH, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        GeneralUtil.LineConnectingType type = (GeneralUtil.LineConnectingType)state.getValue((Property)TYPE);
        if (type == GeneralUtil.LineConnectingType.MIDDLE) {
            return TOP_SHAPE;
        }
        if (direction == Direction.NORTH && type == GeneralUtil.LineConnectingType.LEFT || direction == Direction.SOUTH && type == GeneralUtil.LineConnectingType.RIGHT) {
            return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[0], LEG_SHAPES[3]});
        }
        if (direction == Direction.NORTH && type == GeneralUtil.LineConnectingType.RIGHT || direction == Direction.SOUTH && type == GeneralUtil.LineConnectingType.LEFT) {
            return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[1], LEG_SHAPES[2]});
        }
        if (direction == Direction.EAST && type == GeneralUtil.LineConnectingType.LEFT || direction == Direction.WEST && type == GeneralUtil.LineConnectingType.RIGHT) {
            return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[0], LEG_SHAPES[1]});
        }
        if (direction == Direction.EAST && type == GeneralUtil.LineConnectingType.RIGHT || direction == Direction.WEST && type == GeneralUtil.LineConnectingType.LEFT) {
            return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{LEG_SHAPES[2], LEG_SHAPES[3]});
        }
        return Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])LEG_SHAPES);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPos;
        Level world;
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf((world = context.getLevel()).getFluidState(clickedPos = context.getClickedPos()).getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED, HAS_TABLECLOTH});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    static {
        HAS_TABLECLOTH = BooleanProperty.create((String)"has_tablecloth");
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        TOP_SHAPE = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        LEG_SHAPES = new VoxelShape[]{Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0)};
    }
}

