/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.brewery.core.block.entity.StorageBlockEntity;
import net.satisfy.brewery.core.registry.MobEffectRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrinkBlockItem
extends BlockItem {
    private final MobEffect effect;
    private final int baseDuration;

    public DrinkBlockItem(MobEffect effect, int duration, Block block, Item.Properties settings) {
        super(block, settings);
        this.effect = effect;
        this.baseDuration = duration;
    }

    public static void addQuality(ItemStack itemStack, int quality) {
        ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().putInt("brewery.beer_quality", Math.min(Math.max(quality, 1), 3));
    }

    protected BlockState getPlacementState(BlockPlaceContext context) {
        if (!Objects.requireNonNull(context.getPlayer()).isCrouching()) {
            return null;
        }
        BlockState blockState = this.getBlock().getStateForPlacement(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos blockPos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity beerEntity = (StorageBlockEntity)blockEntity;
            beerEntity.setStack(0, itemStack.copyWithCount(1));
        }
        return super.updateCustomBlockEntityTag(blockPos, level, player, itemStack, blockState);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        Player player;
        ItemStack returnStack = super.finishUsingItem(itemStack, level, livingEntity);
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).isCreative()) {
            player.addItem(new ItemStack((ItemLike)ObjectRegistry.BEER_MUG.get()));
        }
        if (livingEntity instanceof ServerPlayer) {
            int quality;
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            int n = quality = itemStack.has(DataComponents.CUSTOM_DATA) && Objects.requireNonNull((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("brewery.beer_quality") ? ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("brewery.beer_quality") : 1;
            int durationMultiplier = quality == 2 ? 3 : (quality == 3 ? 5 : 1);
            Holder holder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this.effect);
            MobEffectInstance current = serverPlayer.getEffect(holder);
            int currentAmp = current != null ? current.getAmplifier() : -1;
            int newAmp = Mth.clamp((int)(currentAmp + 1), (int)0, (int)5);
            serverPlayer.addEffect(new MobEffectInstance(holder, this.baseDuration * durationMultiplier, newAmp));
            Holder<MobEffect> drunkHolder = MobEffectRegistry.holder(MobEffectRegistry.DRUNK);
            MobEffectInstance drunkCurrent = serverPlayer.getEffect(drunkHolder);
            int drunkAmp = drunkCurrent != null ? drunkCurrent.getAmplifier() : -1;
            int newDrunkAmp = Mth.clamp((int)(drunkAmp + 1), (int)0, (int)5);
            int min = 1800;
            int max = quality == 1 ? 9600 : (quality == 2 ? 6000 : 3600);
            int drunkDuration = Mth.nextInt((RandomSource)level.getRandom(), (int)min, (int)max);
            serverPlayer.addEffect(new MobEffectInstance(drunkHolder, drunkDuration, newDrunkAmp));
        }
        return returnStack;
    }

    @NotNull
    private MobEffectInstance calculateEffectForQuality(int quality) {
        int durationMultiplier = 1;
        int effectLevel = switch (quality) {
            case 2 -> {
                durationMultiplier = 3;
                yield 2;
            }
            case 3 -> {
                durationMultiplier = 5;
                yield 3;
            }
            default -> 1;
        };
        return new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this.effect), this.baseDuration * durationMultiplier, effectLevel - 1);
    }

    public void addCount(ItemStack resultSack, int solved) {
        resultSack.setCount(solved);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        int effectLevel;
        int beerQuality = stack.has(DataComponents.CUSTOM_DATA) && Objects.requireNonNull((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("brewery.beer_quality") ? ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("brewery.beer_quality") : 1;
        int durationMultiplier = 1;
        switch (beerQuality) {
            case 2: {
                durationMultiplier = 3;
                int n = 2;
                break;
            }
            case 3: {
                durationMultiplier = 5;
                int n = 3;
                break;
            }
            default: {
                int n = effectLevel = 1;
            }
        }
        if (this.effect != null) {
            MutableComponent effectName = Component.translatable((String)this.effect.getDescriptionId());
            if (effectLevel > 1) {
                effectName.append(" ").append((Component)Component.translatable((String)("potion.potency." + (effectLevel - 1))));
            }
            int seconds = this.baseDuration * durationMultiplier / 20;
            MutableComponent effectDuration = Component.literal((String)(" (" + seconds + "s)"));
            tooltip.add((Component)effectName.append((Component)effectDuration).withStyle(this.effect.getCategory().getTooltipFormatting()));
        } else {
            tooltip.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        }
        if (beerQuality > 1) {
            tooltip.add((Component)Component.translatable((String)"tooltip.brewery.beer_quality", (Object[])new Object[]{beerQuality}).withStyle(ChatFormatting.GOLD));
        }
    }
}

