/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.client.FarmAndCharmClient;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class PetBowlBlock
extends FacingBlock
implements EntityBlock {
    public static final EnumProperty<GeneralUtil.FoodType> FOOD_TYPE = EnumProperty.create((String)"food_type", GeneralUtil.FoodType.class);
    public static final BooleanProperty HAS_NAME_TAG = BooleanProperty.create((String)"has_name_tag");
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75);
    public static final Map<Direction, VoxelShape> SHAPE = new HashMap<Direction, VoxelShape>();

    public PetBowlBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.COLOR_BROWN));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FOOD_TYPE, (Comparable)((Object)GeneralUtil.FoodType.NONE))).setValue((Property)HAS_NAME_TAG, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FOOD_TYPE, HAS_NAME_TAG});
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        GeneralUtil.FoodType type;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof PetBowlBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        PetBowlBlockEntity entity = (PetBowlBlockEntity)blockEntity;
        if (heldItem.is(Items.SHEARS) && ((Boolean)state.getValue((Property)HAS_NAME_TAG)).booleanValue()) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)HAS_NAME_TAG, (Comparable)Boolean.valueOf(false)), 3);
                PetBowlBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.NAME_TAG));
                if (!player.getAbilities().instabuild) {
                    heldItem.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(player.getItemInHand(hand)));
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.is(Items.NAME_TAG) && !((Boolean)state.getValue((Property)HAS_NAME_TAG)).booleanValue()) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)HAS_NAME_TAG, (Comparable)Boolean.valueOf(true)), 3);
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)HAS_NAME_TAG)).booleanValue() && player.isShiftKeyDown()) {
            if (level.isClientSide) {
                FarmAndCharmClient.openPetBowlScreen(entity);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (!level.isClientSide && hand == InteractionHand.MAIN_HAND && state.getValue(FOOD_TYPE) == GeneralUtil.FoodType.NONE && (type = this.getFoodType(heldItem)) != GeneralUtil.FoodType.NONE) {
            level.setBlock(pos, (BlockState)state.setValue(FOOD_TYPE, (Comparable)((Object)type)), 3);
            if (!player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            entity.setItem(0, new ItemStack((ItemLike)heldItem.getItem()));
            entity.onFed(heldItem);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private GeneralUtil.FoodType getFoodType(ItemStack stack) {
        if (stack.is((Item)ObjectRegistry.CAT_FOOD.get())) {
            return GeneralUtil.FoodType.CAT;
        }
        if (stack.is((Item)ObjectRegistry.DOG_FOOD.get())) {
            return GeneralUtil.FoodType.DOG;
        }
        return GeneralUtil.FoodType.NONE;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PetBowlBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.getValue((Property)FACING));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"tooltip.farm_and_charm.canbeplaced").withStyle(ChatFormatting.GRAY));
    }

    static {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            SHAPE.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    }
}

