/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.entity.WaterSprinklerBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.NotNull;

public class WaterSprinklerBlock
extends BaseEntityBlock {
    public static final MapCodec<WaterSprinklerBlock> CODEC = WaterSprinklerBlock.simpleCodec(WaterSprinklerBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0625, (double)0.0625, (double)0.0625, (double)0.125, (double)0.75, (double)0.9375), Shapes.box((double)0.875, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.75, (double)0.9375), Shapes.box((double)0.125, (double)0.0625, (double)0.0625, (double)0.875, (double)0.75, (double)0.125), Shapes.box((double)0.125, (double)0.0625, (double)0.875, (double)0.875, (double)0.75, (double)0.9375), Shapes.box((double)0.4375, (double)0.125, (double)0.4375, (double)0.5625, (double)1.0625, (double)0.5625)});

    public WaterSprinklerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public void onPlace(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        if (!world.isClientSide) {
            world.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void animateTick(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity be;
        if (!world.isRaining() && !world.isThundering() && world.isClientSide && (be = world.getBlockEntity(pos)) instanceof WaterSprinklerBlockEntity) {
            WaterSprinklerBlockEntity sprinkler = (WaterSprinklerBlockEntity)be;
            float angle = sprinkler.getRotationAngle();
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + 0.5;
            double velocity = 0.2;
            double startOffset = 0.5;
            for (int i = 0; i < 4; ++i) {
                double a = Math.toRadians(angle + (float)(90 * i));
                double cos = Math.cos(a);
                double sin = Math.sin(a);
                double dx = cos * velocity;
                double dz = sin * velocity;
                double startX = x + cos * startOffset;
                double startZ = z + sin * startOffset;
                for (double len = 0.0; len < 3.0; len += 0.5) {
                    double cx = startX + dx * len;
                    double cz = startZ + dz * len;
                    world.addParticle((ParticleOptions)ParticleTypes.SPLASH, cx, y, cz, dx, 0.0, dz);
                }
            }
        }
    }

    public void tick(@NotNull BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4)).forEach(p -> {
            BlockState bs = world.getBlockState(p);
            if (bs.is(Blocks.FARMLAND) || bs.is((Block)ObjectRegistry.FERTILIZED_FARM_BLOCK.get())) {
                world.setBlock(p, (BlockState)bs.setValue((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7)), 2);
            }
            if (bs.is(Blocks.FIRE)) {
                world.removeBlock(p, false);
                world.playSound(null, p, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
            }
            if ((bs.is(Blocks.CAMPFIRE) || bs.is(Blocks.SOUL_CAMPFIRE)) && ((Boolean)bs.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                world.setBlock(p, (BlockState)bs.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
                world.playSound(null, p, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            if (bs.getBlock() instanceof CandleBlock && ((Boolean)bs.getValue((Property)CandleBlock.LIT)).booleanValue()) {
                world.setBlock(p, (BlockState)bs.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
                world.playSound(null, p, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        });
        world.playSound(null, pos, (SoundEvent)SoundEventRegistry.WATER_SPRINKLER.get(), SoundSource.BLOCKS, 0.25f, 0.75f);
        world.scheduleTick(pos, (Block)this, 20);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new WaterSprinklerBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

