/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GrandmothersRecipeBookItem
extends Item {
    private static final Map<ServerLevel, Map<UUID, Set<ResourceLocation>>> worldUnlockedRecipes = new HashMap<ServerLevel, Map<UUID, Set<ResourceLocation>>>();

    public GrandmothersRecipeBookItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            ArrayList<ResourceLocation> recipeIds = new ArrayList<ResourceLocation>();
            if (data != null && data.contains("Recipes")) {
                ListTag list = data.copyTag().getList("Recipes", 8);
                for (int i = 0; i < list.size(); ++i) {
                    recipeIds.add(ResourceLocation.parse((String)list.getString(i)));
                }
            } else if (data.contains("Recipe")) {
                recipeIds.add(ResourceLocation.parse((String)data.copyTag().getString("Recipe")));
            }
            if (!recipeIds.isEmpty()) {
                RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
                for (ResourceLocation id : recipeIds) {
                    Optional opt = manager.byKey(id);
                    if (opt.isPresent()) {
                        RecipeHolder recipe = (RecipeHolder)opt.get();
                        ItemStack resultStack = recipe.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                        tooltip.add((Component)Component.translatable((String)"tooltip.farm_and_charm.recipe_unlocker.unlocks", (Object[])new Object[]{resultStack.getHoverName()}).withStyle(ChatFormatting.GRAY));
                        continue;
                    }
                    tooltip.add((Component)Component.translatable((String)"tooltip.farm_and_charm.recipe_unlocker.unlocks", (Object[])new Object[]{id.toString()}).withStyle(ChatFormatting.GRAY));
                }
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = player.getItemInHand(hand);
            CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            if (data != null) {
                ArrayList<ResourceLocation> recipeIds = new ArrayList<ResourceLocation>();
                if (data.contains("Recipes")) {
                    ListTag list = data.copyTag().getList("Recipes", 8);
                    for (int i = 0; i < list.size(); ++i) {
                        recipeIds.add(ResourceLocation.parse((String)list.getString(i)));
                    }
                } else if (data.contains("Recipe")) {
                    recipeIds.add(ResourceLocation.parse((String)data.copyTag().getString("Recipe")));
                }
                if (!recipeIds.isEmpty()) {
                    ResourceLocation firstId;
                    ServerLevel serverLevel = (ServerLevel)serverPlayer.level();
                    Map worldMap = worldUnlockedRecipes.computeIfAbsent(serverLevel, k -> new HashMap());
                    Set unlocked = worldMap.computeIfAbsent(serverPlayer.getUUID(), k -> new HashSet());
                    if (unlocked.contains(firstId = (ResourceLocation)recipeIds.get(0))) {
                        serverPlayer.displayClientMessage((Component)Component.translatable((String)"tooltip.farm_and_charm.recipe_unlocker.already_unlocked").withStyle(ChatFormatting.RED), false);
                        return InteractionResultHolder.success((Object)stack);
                    }
                    RecipeManager manager = level.getRecipeManager();
                    ArrayList recipes = new ArrayList();
                    for (ResourceLocation id : recipeIds) {
                        Optional opt = manager.byKey(id);
                        opt.ifPresent(recipes::add);
                        unlocked.add(id);
                    }
                    if (!recipes.isEmpty()) {
                        RecipeHolder firstRecipe = (RecipeHolder)recipes.get(0);
                        ItemStack resultStack = firstRecipe.value().getResultItem((HolderLookup.Provider)level.registryAccess());
                        MutableComponent message = Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.farm_and_charm.recipe_unlocker.unlocked.prefix").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" [").withStyle(ChatFormatting.WHITE)).append((Component)resultStack.getHoverName().copy().withStyle(style -> style.withColor(ChatFormatting.WHITE).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(resultStack))))).append((Component)Component.literal((String)"]").withStyle(ChatFormatting.WHITE));
                        serverPlayer.displayClientMessage((Component)message, false);
                        this.spawnGoldenParticles(serverPlayer);
                        stack.shrink(1);
                        return InteractionResultHolder.success((Object)stack);
                    }
                }
            }
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public static ItemStack createUnlockerForRecipes(GrandmothersRecipeBookItem item, String ... recipeIds) {
        ItemStack stack = new ItemStack((ItemLike)item);
        CompoundTag tag = new CompoundTag();
        if (recipeIds.length == 1) {
            tag.putString("Recipe", recipeIds[0]);
        } else {
            ListTag list = new ListTag();
            for (String id : recipeIds) {
                list.add((Object)StringTag.valueOf((String)id));
            }
            tag.put("Recipes", (Tag)list);
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        return stack;
    }

    private void spawnGoldenParticles(final ServerPlayer serverPlayer) {
        final ServerLevel serverLevel = (ServerLevel)serverPlayer.level();
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(this){
            int ticks = 0;

            @Override
            public void run() {
                if (this.ticks >= 40) {
                    timer.cancel();
                    return;
                }
                serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.84f, 0.0f), 1.0f), serverPlayer.getX(), serverPlayer.getY() + 1.0, serverPlayer.getZ(), 5, 0.5, 0.5, 0.5, 0.0);
                ++this.ticks;
            }
        }, 0L, 50L);
    }
}

