/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.item.crafting;

import com.mojang.serialization.MapCodec;
import fuzs.arcanelanterns.init.ModRegistry;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class LanternMakingRecipe
extends ShapelessRecipe {
    public LanternMakingRecipe(ShapelessRecipe recipe) {
        this(recipe.getGroup(), recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), (NonNullList<Ingredient>)recipe.getIngredients());
    }

    public LanternMakingRecipe(String string, ItemStack itemStack, NonNullList<Ingredient> nonNullList) {
        super(string, CraftingBookCategory.MISC, itemStack, nonNullList);
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRegistry.LANTERN_MAKING_RECIPE_TYPE.value();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.LANTERN_MAKING_RECIPE_SERIALIZER.value();
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getToastSymbol() {
        return ((Item)ModRegistry.LANTERN_MAKER_ITEM.value()).getDefaultInstance();
    }

    public static class Serializer
    implements RecipeSerializer<LanternMakingRecipe> {
        public MapCodec<LanternMakingRecipe> codec() {
            return RecipeSerializer.SHAPELESS_RECIPE.codec().xmap(LanternMakingRecipe::new, Function.identity());
        }

        public StreamCodec<RegistryFriendlyByteBuf, LanternMakingRecipe> streamCodec() {
            return RecipeSerializer.SHAPELESS_RECIPE.streamCodec().map(LanternMakingRecipe::new, Function.identity());
        }
    }
}

