/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.oceansdelight.datagen;

import com.mojang.logging.LogUtils;
import com.scouter.oceansdelight.blocks.ODBlocks;
import com.scouter.oceansdelight.creativetabs.ODTabs;
import com.scouter.oceansdelight.items.ODItems;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.slf4j.Logger;

public class LanguageGenerator
extends LanguageProvider {
    private static final Logger LOGGER = LogUtils.getLogger();

    public LanguageGenerator(DataGenerator gen) {
        super(gen.getPackOutput(), "oceansdelight", "en_us");
    }

    protected void addTranslations() {
        this.addBlock((Supplier)ODBlocks.GUARDIAN_SOUP, "Guardian Soup");
        this.addItem((Supplier)ODItems.TENTACLES, "Tentacles");
        this.addItem((Supplier)ODItems.CUT_TENTACLES, "Cut Tentacles");
        this.addItem((Supplier)ODItems.TENTACLE_ON_A_STICK, "Tentacle on a Stick");
        this.addItem((Supplier)ODItems.BAKED_TENTACLE_ON_A_STICK, "Baked Tentacle on a Stick");
        this.addItem((Supplier)ODItems.SQUID_RINGS, "Squid Rings");
        this.addItem((Supplier)ODItems.GUARDIAN, "Guardian");
        this.addItem((Supplier)ODItems.GUARDIAN_TAIL, "Guardian Tail");
        this.addItem((Supplier)ODItems.COOKED_GUARDIAN_TAIL, "Cooked Guardian Tail");
        this.addItem((Supplier)ODItems.BOWL_OF_GUARDIAN_SOUP, "Bowl of Guardian Soup");
        this.addItem((Supplier)ODItems.ELDER_GUARDIAN_SLAB, "Slab of Elder Guardian");
        this.addItem((Supplier)ODItems.ELDER_GUARDIAN_SLICE, "Slice of Elder Guardian");
        this.addItem((Supplier)ODItems.COOKED_ELDER_GUARDIAN_SLICE, "Cooked Slice of Elder Guardian");
        this.addItem((Supplier)ODItems.ELDER_GUARDIAN_ROLL, "Roll of Elder Guardian");
        this.addItem((Supplier)ODItems.CABBAGE_WRAPPED_ELDER_GUARDIAN, "Cabbage Wrapped Elder Guardian");
        this.addItem((Supplier)ODItems.BRAISED_SEA_PICKLE, "Braised Sea Pickle");
        this.addItem((Supplier)ODItems.FUGU_ROLL, "Fugu Roll");
        this.addItem((Supplier)ODItems.FUGU_SLICE, "Fugu Slice");
        this.addItem((Supplier)ODItems.SEAGRASS_SALAD, "Seagrass Salad");
        this.addItem((Supplier)ODItems.STUFFED_COD, "Stuffed Cod");
        this.addItem((Supplier)ODItems.COOKED_STUFFED_COD, "Cooked Stuffed Cod");
        this.addItem((Supplier)ODItems.HONEY_FRIED_KELP, "Honey Fried Kelp");
        this.addTabName((CreativeModeTab)ODTabs.OD_TAB.get(), "Ocean's Delight");
    }

    public String getName() {
        return "Ocean's Delight Languages: en_us";
    }

    public void addTabName(CreativeModeTab key, String name) {
        this.add(key.getDisplayName().getString(), name);
    }

    public void add(CreativeModeTab key, String name) {
        this.add(key.getDisplayName().getString(), name);
    }

    public void addPotion(Supplier<? extends Potion> key, String name, String regName) {
        this.add(key.get(), name, regName);
    }

    public void add(Potion key, String name, String regName) {
        this.add("item.minecraft.potion.effect." + regName, name);
        this.add("item.minecraft.splash_potion.effect." + regName, "Splash " + name);
        this.add("item.minecraft.lingering_potion.effect." + regName, "Lingering " + name);
    }
}

