/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.gui;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class KegTooltip
implements ClientTooltipComponent {
    private static final int ITEM_SIZE = 16;
    private static final int MARGIN = 4;
    private final int textSpacing;
    private final AbstractedFluidStack mealStack;

    public KegTooltip(KegTooltipComponent tooltip) {
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.textSpacing = 9 + 1;
        this.mealStack = tooltip.mealStack;
    }

    public int getHeight() {
        return this.mealStack.isEmpty() ? this.textSpacing : this.textSpacing + 16;
    }

    public int getWidth(Font font) {
        if (!this.mealStack.isEmpty()) {
            MutableComponent textServingsOf = this.mealStack.amount() == FluidUnit.MILLIBUCKET.convertToLoader(250L) ? TextUtils.getTranslation((String)"tooltip.cooking_pot.single_serving", (Object[])new Object[0]) : TextUtils.getTranslation((String)"tooltip.cooking_pot.many_servings", (Object[])new Object[]{this.mealStack.amount() / FluidUnit.MILLIBUCKET.convertToLoader(250L)});
            return Math.max(font.width((FormattedText)textServingsOf), font.width((FormattedText)BrewinAndChewin.getHelper().getFluidDisplayName(this.mealStack)) + 20);
        }
        return font.width((FormattedText)TextUtils.getTranslation((String)"tooltip.cooking_pot.empty", (Object[])new Object[0]));
    }

    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics gui) {
        if (this.mealStack.isEmpty()) {
            return;
        }
        ItemStack itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), this.mealStack);
        gui.renderItem(itemDisplay, mouseX, mouseY + 9);
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
        int gray;
        Integer color = ChatFormatting.GRAY.getColor();
        int n = gray = color == null ? -1 : color;
        if (!this.mealStack.isEmpty()) {
            MutableComponent textServingsOf = this.mealStack.amount() == FluidUnit.MILLIBUCKET.convertToLoader(250L) ? TextUtils.getTranslation((String)"tooltip.cooking_pot.single_serving", (Object[])new Object[0]) : TextUtils.getTranslation((String)"tooltip.cooking_pot.many_servings", (Object[])new Object[]{this.mealStack.amount() / FluidUnit.MILLIBUCKET.convertToLoader(250L)});
            font.drawInBatch((Component)textServingsOf, (float)x, (float)y, gray, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            font.drawInBatch(BrewinAndChewin.getHelper().getFluidDisplayName(this.mealStack), (float)(x + 16 + 4), (float)(y + this.textSpacing + 4), -1, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else {
            MutableComponent textEmpty = TextUtils.getTranslation((String)"tooltip.cooking_pot.empty", (Object[])new Object[0]);
            font.drawInBatch((Component)textEmpty, (float)x, (float)y, gray, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public record KegTooltipComponent(AbstractedFluidStack mealStack) implements TooltipComponent
    {
    }
}

