/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import umpaz.brewinandchewin.common.block.CoasterBlock;
import umpaz.brewinandchewin.common.registry.BnCBlockEntityTypes;
import umpaz.brewinandchewin.common.registry.BnCItems;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;

public class CoasterBlockEntity
extends SyncedBlockEntity {
    public final NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);

    public CoasterBlockEntity(BlockPos pos, BlockState state) {
        super(BnCBlockEntityTypes.COASTER, pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, Level level, BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (!player.getAbilities().mayBuild) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (((Boolean)state.getValue((Property)CoasterBlock.INVISIBLE)).booleanValue() && stack.is(BnCItems.COASTER)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CoasterBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)));
            return ItemInteractionResult.SUCCESS;
        }
        if ((Integer)state.getValue((Property)CoasterBlock.SIZE) < 4 && this.addItem(level, pos, state, stack, player.getAbilities().instabuild, (Integer)state.getValue((Property)CoasterBlock.SIZE))) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if ((Integer)state.getValue((Property)CoasterBlock.SIZE) > 0) {
            if (player.isShiftKeyDown() && !((Boolean)state.getValue((Property)CoasterBlock.INVISIBLE)).booleanValue()) {
                ItemStack coaster = new ItemStack((ItemLike)BnCItems.COASTER);
                if (!player.getAbilities().instabuild && !player.addItem(coaster)) {
                    player.drop(coaster, false);
                }
                level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.BLOCKS);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CoasterBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)));
                return InteractionResult.SUCCESS;
            }
            int count = (Integer)state.getValue((Property)CoasterBlock.SIZE);
            if (!player.getAbilities().instabuild && !player.addItem((ItemStack)this.inventory.get(count - 1))) {
                player.drop((ItemStack)this.inventory.get(count - 1), false);
            }
            BlockState replaceWith = Blocks.AIR.defaultBlockState();
            if (!((Boolean)state.getValue((Property)CoasterBlock.INVISIBLE)).booleanValue() || count > 1) {
                replaceWith = (BlockState)state.setValue((Property)CoasterBlock.SIZE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)CoasterBlock.SIZE) - 1));
            }
            level.setBlockAndUpdate(pos, replaceWith);
            this.inventory.set(count - 1, (Object)ItemStack.EMPTY);
            this.inventoryChanged();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean addItem(Level level, BlockPos pos, BlockState state, ItemStack stack, boolean instabuild, int index) {
        if (stack.isEmpty()) {
            return false;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)CoasterBlock.SIZE, (Comparable)Integer.valueOf(index + 1)), 3);
        this.inventory.set(index, (Object)stack.copyWithCount(1));
        this.inventoryChanged();
        if (!instabuild) {
            stack.shrink(1);
        }
        return true;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.inventory.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.getBlockPos();
        return AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)pos, (Vec3i)pos.above()));
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }
}

