/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.effect;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class SweetHeartEffect
extends MobEffect {
    public SweetHeartEffect() {
        super(MobEffectCategory.BENEFICIAL, 16711769);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int k = 20 >> amplifier;
        if (k > 0) {
            return duration % k == 0;
        }
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        ServerPlayer player;
        float saturation;
        if (entity instanceof ServerPlayer && (saturation = (player = (ServerPlayer)entity).getFoodData().getSaturationLevel()) > 0.0f && player.getHealth() < player.getMaxHealth()) {
            float healingAmount = Math.min(saturation, 1.0f);
            player.heal(healingAmount);
            player.getFoodData().setSaturation(saturation - healingAmount);
        }
        return true;
    }
}

