/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.data.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public class KegPouringRecipeBuilder {
    private ItemStack container;
    private final Fluid fluid;
    private final int amount;
    private Optional<FluidUnit> unit = Optional.empty();
    private final ItemStack output;
    private final boolean strict;
    private final boolean filling;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private boolean includeCreateRecipes = true;

    private KegPouringRecipeBuilder(Fluid fluid, int amount, ItemStack output, boolean strict, boolean filling) {
        this.fluid = fluid;
        this.amount = amount;
        this.output = output;
        this.strict = strict;
        this.filling = filling;
    }

    public static KegPouringRecipeBuilder kegPouringRecipe(Fluid fluid, int amount, ItemStack output, boolean strict) {
        return new KegPouringRecipeBuilder(fluid, amount, output, strict, true);
    }

    public static KegPouringRecipeBuilder kegPouringRecipe(Fluid fluid, int amount, ItemStack output, boolean strict, boolean filling) {
        return new KegPouringRecipeBuilder(fluid, amount, output, strict, filling);
    }

    public static KegPouringRecipeBuilder kegPouringRecipe(Fluid fluid, int amount, ItemLike output) {
        return new KegPouringRecipeBuilder(fluid, amount, output.asItem().getDefaultInstance(), false, true);
    }

    public static KegPouringRecipeBuilder kegPouringRecipe(Fluid fluid, int amount, ItemLike output, boolean filling) {
        return new KegPouringRecipeBuilder(fluid, amount, output.asItem().getDefaultInstance(), false, filling);
    }

    public KegPouringRecipeBuilder setFluidUnit(FluidUnit unit) {
        this.unit = Optional.of(unit);
        return this;
    }

    public KegPouringRecipeBuilder withContainer(ItemLike container) {
        this.container = container.asItem().getDefaultInstance();
        return this;
    }

    public KegPouringRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public KegPouringRecipeBuilder excludeCreateCompat() {
        this.includeCreateRecipes = false;
        return this;
    }

    public void build(RecipeOutput consumerIn) {
        ResourceLocation outputLocation = BuiltInRegistries.ITEM.getKey((Object)this.output.getItem());
        this.build(consumerIn, "brewinandchewin:pouring/" + outputLocation.getPath());
    }

    public void build(RecipeOutput consumerIn, String save) {
        ResourceLocation resourcelocation = BuiltInRegistries.ITEM.getKey((Object)this.output.getItem());
        if (resourcelocation.equals((Object)ResourceLocation.tryParse((String)save))) {
            throw new IllegalStateException("Pouring Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, ResourceLocation.tryParse((String)save));
    }

    public void build(RecipeOutput consumerIn, ResourceLocation id) {
        if (!this.output.hasCraftingRemainingItem() && this.container == null) {
            throw new IllegalStateException("Pouring Recipe " + String.valueOf(id) + " must specify a container as the output does not have a remainder.");
        }
        consumerIn.accept(id, (Recipe)new KegPouringRecipe(new AbstractedFluidStack(this.fluid, this.amount), Optional.ofNullable(this.container), this.output, this.unit, this.strict, this.filling), null);
    }
}

