/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createliquidfuel.core;

import com.forsteri.createliquidfuel.core.BurnerStomachHandler;
import com.forsteri.createliquidfuel.util.Triplet;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class LiquidBurnerFuelJsonLoader
extends SimpleJsonResourceReloadListener {
    public static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"createliquidfuel", (String)"drainable_fuel_loader");
    private static final Gson GSON = new Gson();
    public static final LiquidBurnerFuelJsonLoader INSTANCE = new LiquidBurnerFuelJsonLoader();

    public LiquidBurnerFuelJsonLoader() {
        super(GSON, "compat");
    }

    protected void apply(Map<ResourceLocation, JsonElement> p_10793_, @NotNull ResourceManager p_10794_, @NotNull ProfilerFiller p_10795_) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : p_10793_.entrySet()) {
            JsonElement element = entry.getValue();
            if (!element.isJsonObject()) continue;
            ResourceLocation id = entry.getKey();
            JsonObject object = element.getAsJsonObject();
            JsonElement fluidElement = object.get("fluid");
            if (fluidElement != null) {
                try {
                    Optional value = BuiltInRegistries.FLUID.getOptional(ResourceLocation.parse((String)fluidElement.getAsString()));
                    if (!value.isPresent()) continue;
                    BurnerStomachHandler.LIQUID_BURNER_FUEL_MAP.put((Fluid)value.get(), (Pair<ResourceLocation, Triplet<Integer, Boolean, Integer>>)Pair.of((Object)IDENTIFIER, Triplet.of(object.has("burnTime") ? object.get("burnTime").getAsInt() : (object.has("superHeat") && object.get("superHeat").getAsBoolean() ? 32 : 20), object.has("superHeat") && object.get("superHeat").getAsBoolean(), object.has("amountConsumedPerTick") ? object.get("amountConsumedPerTick").getAsInt() : (object.has("superHeat") && object.get("superHeat").getAsBoolean() ? 10 : 1))));
                    continue;
                }
                catch (ResourceLocationException e) {
                    throw new RuntimeException("Fluid liquid burner fuel " + String.valueOf(id) + " has invalid fluid: " + fluidElement.getAsString());
                }
            }
            throw new RuntimeException("No fluid specified for liquid burner fuel: " + String.valueOf(id));
        }
    }
}

