/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.biome;

import com.epherical.croptopia.CroptopiaMod;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeGenerationSettingsBuilder;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredHolder;

public record CropModifier(GenerationStep.Decoration step, Holder<PlacedFeature> feature) implements BiomeModifier
{
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<CropModifier>> SERIALIZER = CroptopiaMod.BIOME_SERIALIZER.register("crops", CropModifier::makeCodec);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            BiomeGenerationSettingsBuilder generation = builder.getGenerationSettings();
            generation.addFeature(this.step, this.feature);
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)SERIALIZER.get();
    }

    public static MapCodec<CropModifier> makeCodec() {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.comapFlatMap(CropModifier::generationStageFromString, GenerationStep.Decoration::getName).fieldOf("generation_stage").forGetter(CropModifier::step), (App)PlacedFeature.CODEC.fieldOf("feature").forGetter(CropModifier::feature)).apply((Applicative)builder, CropModifier::new));
    }

    private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
        try {
            return DataResult.success((Object)GenerationStep.Decoration.valueOf((String)name.toUpperCase(Locale.ROOT)));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Not a decoration stage: " + name);
        }
    }
}

