/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.datagen;

import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.Tree;
import com.epherical.croptopia.register.helpers.TreeCrop;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class CroptopiaBlockTagProvider
extends IntrinsicHolderTagsProvider<Block> {
    public CroptopiaBlockTagProvider(PackOutput output, ResourceKey<? extends Registry<Block>> registryKey, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, registryKey, lookupProvider, o -> o.builtInRegistryHolder().key(), "croptopia", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider arg) {
        this.generateSaplings();
        this.generateBarkLogs();
        this.generateLeaves();
        this.generateCrops();
        this.generateMisc();
    }

    protected void generateSaplings() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender saplings = this.tag(BlockTags.SAPLINGS);
        for (TreeCrop treeCrop : TreeCrop.copy()) {
            saplings.add((Object)treeCrop.getSaplingBlock());
        }
        for (Tree tree : Tree.copy()) {
            saplings.add((Object)tree.getSaplingBlock());
        }
    }

    protected void generateBarkLogs() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender burnableLog = this.tag(BlockTags.LOGS_THAT_BURN);
        for (Tree crop : Tree.copy()) {
            this.tag(crop.getLogBlockTag()).add((Object)crop.getLog()).add((Object)crop.getStrippedLog()).add((Object)crop.getWood()).add((Object)crop.getStrippedWood());
            burnableLog.addTag(crop.getLogBlockTag());
        }
    }

    protected void generateLeaves() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender leaves = this.tag(BlockTags.LEAVES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender hoe = this.tag(BlockTags.MINEABLE_WITH_HOE);
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            leaves.add((Object)treeCrop.getLeaves());
            hoe.add((Object)treeCrop.getLeaves());
        }
        for (Tree tree : Tree.copy()) {
            leaves.add((Object)tree.getLeaves());
            hoe.add((Object)tree.getLeaves());
        }
    }

    protected void generateCrops() {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender crops = this.tag(BlockTags.CROPS);
        for (FarmlandCrop farmlandCrop : FarmlandCrop.copy()) {
            crops.add((Object)farmlandCrop.asBlock());
        }
        for (TreeCrop treeCrop : TreeCrop.copy()) {
            crops.add((Object)treeCrop.asBlock());
        }
    }

    protected void generateMisc() {
        this.tag(BlockTags.MINEABLE_WITH_SHOVEL).add((Object)Content.SALT_ORE_BLOCK);
        this.tag(BlockTags.AZALEA_ROOT_REPLACEABLE).add((Object)Content.SALT_ORE_BLOCK);
        this.tag(BlockTags.DRIPSTONE_REPLACEABLE).add((Object)Content.SALT_ORE_BLOCK);
        this.tag(BlockTags.ENDERMAN_HOLDABLE).add((Object)Content.SALT_ORE_BLOCK);
    }
}

