/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.datagen;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.LeafCropBlock;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.Tree;
import com.epherical.croptopia.register.helpers.TreeCrop;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.AddTableLootModifier;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public class CroptopiaLootTableProvider
extends BlockLootSubProvider {
    public static final ResourceKey<LootTable> TUNA_SANDWICH_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CroptopiaMod.createIdentifier("chests/tuna_sandwich_loot"));
    public static final ResourceKey<LootTable> MOUNTAIN_SALT_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CroptopiaMod.createIdentifier("chests/mountain_salt_loot"));
    public static final ResourceKey<LootTable> COD_ROE_DROP = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CroptopiaMod.createIdentifier("entities/cod_roe_drop"));
    public static final ResourceKey<LootTable> SALMON_ROE_DROP = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CroptopiaMod.createIdentifier("entities/salmon_roe_drop"));
    public static final ResourceKey<LootTable> TROPICAL_ROE_DROP = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CroptopiaMod.createIdentifier("entities/tropical_roe_drop"));
    public static final ResourceKey<LootTable> GLOWING_SQUID_GLOW_CALAMARI = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CroptopiaMod.createIdentifier("entities/glowing_squid_glowing_calamari_drop"));
    public static final ResourceKey<LootTable> SQUID_CALAMARI_DROP = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CroptopiaMod.createIdentifier("entities/squid_calamari_drop"));
    public static final ResourceKey<LootTable> RAVAGER_MEAT_DROP = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CroptopiaMod.createIdentifier("entities/ravager_meat_drop"));
    public static final ResourceKey<LootTable> CROPTOPIA_FISHING_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)CroptopiaMod.createIdentifier("gameplay/fishing"));

    public CroptopiaLootTableProvider(HolderLookup.Provider registries) {
        super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().equals("croptopia")).map(Map.Entry::getValue).toList();
    }

    protected void generate() {
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            LootItemBlockStatePropertyCondition.Builder ageCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)farmlandCrop.asBlock()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.AGE_7, 7));
            this.add(farmlandCrop.asBlock(), (LootTable.Builder)this.applyExplosionDecay((ItemLike)farmlandCrop.asBlock(), (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)ageCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)farmlandCrop.asItem()).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3))))));
        }
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            CopyBlockState.Builder copyState = CopyBlockState.copyState((Block)treeCrop.asBlock()).copy((Property)LeafCropBlock.AGE);
            LootItemBlockStatePropertyCondition.Builder ageCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)treeCrop.asBlock()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.AGE_3, 3));
            LootItemCondition.Builder shearsCondition = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}));
            LootItemCondition.Builder notShearsCondition = shearsCondition.invert();
            this.add(treeCrop.asBlock(), (LootTable.Builder)this.applyExplosionDecay((ItemLike)treeCrop.asBlock(), (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)treeCrop.asItem()).when(notShearsCondition)).when((LootItemCondition.Builder)ageCondition))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)treeCrop.getSaplingItem()).setWeight(5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(95))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)treeCrop.getLeavesItem()).when(shearsCondition)).apply((LootItemFunction.Builder)copyState)))));
            this.dropSelf(treeCrop.getSaplingBlock());
        }
        for (Tree tree : Tree.copy()) {
            this.dropSelf(tree.asBlock());
            this.dropSelf(tree.getSaplingBlock());
            this.dropSelf(tree.getWood());
            this.dropSelf(tree.getStrippedLog());
            this.dropSelf(tree.getStrippedWood());
            this.dropSelf(tree.getLog());
            this.add(tree.getLeaves(), block -> this.createLeavesDrops((Block)block, tree.getSaplingBlock(), NORMAL_LEAVES_SAPLING_CHANCES));
        }
        this.add(Content.SALT_ORE_BLOCK, block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Content.SALT).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (int)2)))));
    }

    public static class GlobalLootProvider
    extends GlobalLootModifierProvider {
        public GlobalLootProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries, "croptopia");
        }

        protected void start() {
            this.add("add_tuna_to_dungeon", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.SIMPLE_DUNGEON.location()).build()}, TUNA_SANDWICH_LOOT), new ICondition[0]);
            this.add("add_mountain_salt_to_shipwreck", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.SHIPWRECK_TREASURE.location()).build()}, MOUNTAIN_SALT_LOOT), new ICondition[0]);
            this.add("add_roe_to_cod", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entities/cod")).build()}, COD_ROE_DROP), new ICondition[0]);
            this.add("add_roe_to_salmon", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entities/salmon")).build()}, SALMON_ROE_DROP), new ICondition[0]);
            this.add("add_roe_to_tropical_fish", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entities/tropical_fish")).build()}, TROPICAL_ROE_DROP), new ICondition[0]);
            this.add("add_calamari_to_squid", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entities/squid")).build()}, SQUID_CALAMARI_DROP), new ICondition[0]);
            this.add("add_ravager_meat_to_ravager", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entities/ravager")).build()}, RAVAGER_MEAT_DROP), new ICondition[0]);
            this.add("add_glowing_calamari_to_glowing_squid", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entities/glow_squid")).build()}, GLOWING_SQUID_GLOW_CALAMARI), new ICondition[0]);
            this.add("add_croptopia_fish_to_aquaculture", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"gameplay/fishing/fish")).build()}, CROPTOPIA_FISHING_TABLE), new ICondition[0]);
            this.add("add_croptopia_fish_to_minecraft", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.FISHING.location()).build()}, CROPTOPIA_FISHING_TABLE), new ICondition[0]);
        }
    }

    public record ChestLoot(HolderLookup.Provider reg) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            output.accept(TUNA_SANDWICH_LOOT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.TUNA_SANDWICH).setWeight(10)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(90))));
            output.accept(MOUNTAIN_SALT_LOOT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.MOUNTAIN_SALT).setWeight(5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(95))));
        }
    }

    public record EntityLoot(HolderLookup.Provider reg) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            output.accept(COD_ROE_DROP, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.ROE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
            output.accept(SALMON_ROE_DROP, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.ROE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
            output.accept(TROPICAL_ROE_DROP, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.ROE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
            output.accept(GLOWING_SQUID_GLOW_CALAMARI, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.GLOWING_CALAMARI).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))));
            output.accept(SQUID_CALAMARI_DROP, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.CALAMARI).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))));
            output.accept(RAVAGER_MEAT_DROP, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.RAW_RAVAGER_MEAT).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.reg, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }
    }

    public record FishingLoot(HolderLookup.Provider reg) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            output.accept(CROPTOPIA_FISHING_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(65)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.TUNA).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.ANCHOVY).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.SHRIMP).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.CRAB).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.CLAM).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.OYSTER).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Content.SEA_LETTUCE).setQuality(5))));
        }
    }
}

