/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaSaplingBlock;
import com.epherical.croptopia.blocks.LeafCropBlock;
import com.epherical.croptopia.items.CropItem;
import com.epherical.croptopia.items.CroptopiaSaplingItem;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.FoodConstructor;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class TreeCrop
implements ItemConvertibleWithPlural,
BlockConvertible {
    public static final List<TreeCrop> TREE_CROPS = new ArrayList<TreeCrop>();
    private final String name;
    private final boolean isPlural;
    private final TagCategory category;
    private Item item;
    private Block leaves;
    private Item leavesItem;
    private Block leafType;
    private ConfiguredFeature<TreeConfiguration, ?> treeConfig;
    private Item saplingItem;
    private Block saplingBlock;
    private final FoodConstructor constructor;
    private final ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey;
    private final ResourceKey<PlacedFeature> placedFeatureKey;

    public TreeCrop(String name, boolean plural, Block logType, Block leafType, TagCategory category, FoodConstructor constructor, int base, int randA, int randB, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey, ResourceKey<PlacedFeature> placedFeatureKey) {
        Objects.requireNonNull(leafType);
        Objects.requireNonNull(category);
        Objects.requireNonNull(logType);
        Content.BLOCK_REGISTER.reg(register -> {
            this.registerBlock((RegisterFunction<Block>)register);
            this.treeConfig = TreeCrop.createTreeGen(base, randA, randB, logType, leafType, this.leaves);
        });
        Content.ITEM_REGISTER.reg(this::registerItem);
        this.configuredFeatureKey = configuredFeatureKey;
        this.placedFeatureKey = placedFeatureKey;
        this.name = name;
        this.isPlural = plural;
        this.category = category;
        this.constructor = constructor;
        this.leafType = leafType;
        TREE_CROPS.add(this);
    }

    @Override
    public Block asBlock() {
        return this.leaves;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean hasPlural() {
        return this.isPlural;
    }

    public Item asItem() {
        return this.item;
    }

    public ConfiguredFeature<TreeConfiguration, ?> getTreeConfig() {
        return this.treeConfig;
    }

    public Block getSaplingBlock() {
        return this.saplingBlock;
    }

    public Item getSaplingItem() {
        return this.saplingItem;
    }

    public Block getLeaves() {
        return this.leaves;
    }

    public TagCategory getTagCategory() {
        return this.category;
    }

    public ResourceKey<ConfiguredFeature<?, ?>> getConfiguredFeatureKey() {
        return this.configuredFeatureKey;
    }

    public ResourceKey<PlacedFeature> getPlacedFeatureKey() {
        return this.placedFeatureKey;
    }

    public Item getLeavesItem() {
        return this.leavesItem;
    }

    public void registerItem(RegisterFunction<Item> register) {
        if (!Objects.equals(this.name(), "apple")) {
            this.item = register.register(CroptopiaMod.createIdentifier(this.name()), () -> new CropItem(CroptopiaMod.createGroup().food(FoodConstructor.createFood(this.constructor))));
            CroptopiaMod.cropItems.add(this.asItem());
        } else {
            this.item = Items.APPLE;
        }
        this.saplingItem = register.register(CroptopiaMod.createIdentifier(this.name() + "_sapling"), () -> new CroptopiaSaplingItem(this.saplingBlock, this.leaves, this.leafType, CroptopiaMod.createGroup()));
        this.leavesItem = register.register(CroptopiaMod.createIdentifier(this.name() + "_crop"), () -> new BlockItem(this.leaves, CroptopiaMod.createGroup()));
    }

    public void registerBlock(RegisterFunction<Block> register) {
        this.saplingBlock = register.register(CroptopiaMod.createIdentifier(this.name() + "_sapling"), () -> new CroptopiaSaplingBlock(TreeCrop.createTree(this.configuredFeatureKey), CroptopiaMod.createSaplingSettings()));
        this.leaves = register.register(CroptopiaMod.createIdentifier(this.name() + "_crop"), CroptopiaMod::createLeavesBlock);
        CroptopiaMod.cropBlocks.add(this.asBlock());
        CroptopiaMod.cropBlocks.add(this.saplingBlock);
        CroptopiaMod.leafBlocks.add(this.asBlock());
    }

    private static TreeGrower createTree(ResourceKey<ConfiguredFeature<?, ?>> key) {
        return new TreeGrower(key.location().toString(), Optional.empty(), Optional.of(key), Optional.empty());
    }

    public static List<TreeCrop> copy() {
        return TREE_CROPS;
    }

    public static ConfiguredFeature<TreeConfiguration, ?> createTreeGen(int i, int j, int k, Block logType, Block leafType, Block leafCrop) {
        return new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)SimpleStateProvider.simple((BlockState)logType.defaultBlockState()), (TrunkPlacer)new StraightTrunkPlacer(i, j, k), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)leafType.defaultBlockState().setValue((Property)LeafCropBlock.PERSISTENT, (Comparable)Boolean.valueOf(false))), 90).add((Object)((BlockState)leafCrop.defaultBlockState().setValue((Property)LeafCropBlock.AGE, (Comparable)Integer.valueOf(3))), 20).build()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).ignoreVines().build());
    }
}

