/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.chassis;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.chassis.StickerBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class StickerBlock
extends WrenchableDirectionalBlock
implements IBE<StickerBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;

    public StickerBlock(BlockBehaviour.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction nearestLookingDirection = context.getNearestLookingDirection();
        boolean shouldPower = context.getLevel().hasNeighborSignal(context.getClickedPos());
        Direction facing = context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? nearestLookingDirection : nearestLookingDirection.getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(shouldPower));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{POWERED, EXTENDED}));
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.isClientSide) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.getValue((Property)POWERED);
        if (previouslyPowered != worldIn.hasNeighborSignal(pos)) {
            if (((Boolean)(state = (BlockState)state.cycle((Property)POWERED)).getValue((Property)POWERED)).booleanValue()) {
                state = (BlockState)state.cycle((Property)EXTENDED);
            }
            worldIn.setBlock(pos, state, 2);
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    public Class<StickerBlockEntity> getBlockEntityClass() {
        return StickerBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends StickerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.STICKER.get();
    }

    private boolean isUprightSticker(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return AllBlocks.STICKER.has(blockState) && blockState.getValue((Property)FACING) == Direction.UP;
    }

    public void fallOn(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, float p_152430_) {
        if (!this.isUprightSticker((BlockGetter)p_152426_, p_152428_) || p_152429_.isSuppressingBounce()) {
            super.fallOn(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_);
        }
        p_152429_.causeFallDamage(p_152430_, 1.0f, p_152426_.damageSources().fall());
    }

    public void updateEntityAfterFallOn(BlockGetter p_176216_1_, Entity p_176216_2_) {
        if (!this.isUprightSticker(p_176216_1_, p_176216_2_.blockPosition().below()) || p_176216_2_.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(p_176216_1_, p_176216_2_);
        } else {
            this.bounceUp(p_176216_2_);
        }
    }

    private void bounceUp(Entity p_226946_1_) {
        Vec3 Vector3d = p_226946_1_.getDeltaMovement();
        if (Vector3d.y < 0.0) {
            double d0 = p_226946_1_ instanceof LivingEntity ? 1.0 : 0.8;
            p_226946_1_.setDeltaMovement(Vector3d.x, -Vector3d.y * d0, Vector3d.z);
        }
    }

    public void stepOn(Level p_152431_, BlockPos p_152432_, BlockState p_152433_, Entity p_152434_) {
        double d0 = Math.abs(p_152434_.getDeltaMovement().y);
        if (d0 < 0.1 && !p_152434_.isSteppingCarefully() && this.isUprightSticker((BlockGetter)p_152431_, p_152432_)) {
            double d1 = 0.4 + d0 * 0.2;
            p_152434_.setDeltaMovement(p_152434_.getDeltaMovement().multiply(d1, 1.0, d1));
        }
        super.stepOn(p_152431_, p_152432_, p_152433_, p_152434_);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        if (this.isUprightSticker((BlockGetter)worldserver, pos)) {
            worldserver.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SLIME_BLOCK.defaultBlockState()), entity.getX(), entity.getY(), entity.getZ(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
            return true;
        }
        return super.addLandingEffects(state1, worldserver, pos, state2, entity, numberOfParticles);
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (state.getValue((Property)FACING) == Direction.UP) {
            Vec3 Vector3d = entity.getDeltaMovement();
            world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SLIME_BLOCK.defaultBlockState()).setPos(pos), entity.getX() + ((double)world.random.nextFloat() - 0.5) * (double)entity.getBbWidth(), entity.getY() + 0.1, entity.getZ() + ((double)world.random.nextFloat() - 0.5) * (double)entity.getBbWidth(), Vector3d.x * -4.0, 1.5, Vector3d.z * -4.0);
            return true;
        }
        return super.addRunningEffects(state, world, pos, entity);
    }
}

