/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.herbalbrews.core.blocks.entity.StoveBlockEntity;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveBlock
extends SmokerBlock {
    public StoveBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        boolean isLit = (Boolean)world.getBlockState(pos).getValue((Property)LIT);
        if (isLit && !entity.fireImmune() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurt(world.damageSources().inFire(), 1.0f);
        }
        super.stepOn(world, pos, state, entity);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double d = (double)pos.getX() + 0.5;
        double e = (double)pos.getY() + 0.24;
        double f = (double)pos.getZ() + 0.5;
        if (random.nextDouble() < 0.4) {
            world.playLocalSound(d, e, f, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 0.25f, 1.0f, false);
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        Direction.Axis axis = direction.getAxis();
        double h = random.nextDouble() * 0.6 - 0.3;
        double i = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : h;
        double j = random.nextDouble() * 0.375;
        double k = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : h;
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.FLAME, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d, (double)pos.getY() + 1.5, f, 0.0, 0.0, 0.0);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity be;
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)be;
            player.openMenu(provider);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StoveBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return StoveBlock.createFurnaceTicker((Level)level, blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.STOVE_BLOCK_ENTITY.get()));
    }
}

