/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block;

import alabaster.crabbersdelight.common.Config;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeashellBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)0, (int)63);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);

    public SeashellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VARIANT, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VARIANT, FACING, WATERLOGGED});
    }

    private int getVariantCount() {
        return (Integer)Config.SEASHELL_VARIANT_COUNT.get();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        int count = this.getVariantCount();
        int variant = context.getLevel().getRandom().nextInt(count);
        Direction facing = Direction.Plane.HORIZONTAL.getRandomDirection(context.getLevel().getRandom());
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)VARIANT, (Comparable)Integer.valueOf(variant))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (level.getFluidState(pos).getType() == Fluids.WATER) {
            level.setBlock(pos, (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        Vec3 offset = state.getOffset(world, pos);
        return SHAPE.move(offset.x, offset.y, offset.z);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState ground = level.getBlockState(below);
        return ground.isFaceSturdy((BlockGetter)level, below, Direction.UP);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (level.getFluidState(pos).getType() == Fluids.WATER) {
            if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        } else if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return super.updateShape(state, dir, neighborState, level, pos, neighborPos);
    }
}

