/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block.container;

import alabaster.crabbersdelight.CrabbersDelight;
import alabaster.crabbersdelight.common.block.entity.inventory.CrabTrapItemHandler;
import alabaster.crabbersdelight.common.registry.CDModBlocks;
import alabaster.crabbersdelight.common.registry.CDModMenus;
import alabaster.crabbersdelight.common.tags.CDModTags;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class CrabTrapMenu
extends AbstractContainerMenu {
    public final CrabTrapItemHandler inventory;
    private final ContainerLevelAccess access;
    public static final ResourceLocation BAIT_SLOT = CrabbersDelight.modPrefix("gui/bait_slot");

    public CrabTrapMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, new CrabTrapItemHandler(), ContainerLevelAccess.NULL);
    }

    public CrabTrapMenu(int id, Inventory playerInv, CrabTrapItemHandler inventory, ContainerLevelAccess containerLevelAccess) {
        super(CDModMenus.CRAB_TRAP_MENU.get(), id);
        this.inventory = inventory;
        this.access = containerLevelAccess;
        int startX = 8;
        int borderSlotSize = 18;
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)inventory, 0, 80, 13){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(CDModTags.CRAB_TRAP_BAIT);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)TextureAtlas.LOCATION_BLOCKS, (Object)BAIT_SLOT);
            }
        });
        for (int column = 0; column < 9; ++column) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)inventory, column + 1, 8 + column * 18, 34));
        }
        int startPlayerInvY = 65;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)playerInv, 9 + row * 9 + column, startX + column * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInv, column, startX + column * borderSlotSize, 123));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.inventory.getItems().size() ? !this.moveItemStackTo(itemstack1, this.inventory.getItems().size(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.inventory.getItems().size(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return CrabTrapMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)CDModBlocks.CRAB_TRAP.get());
    }
}

