/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.entity.crab;

import alabaster.crabbersdelight.common.entity.crab.CrabAnimations;
import alabaster.crabbersdelight.common.entity.crab.CrabEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CrabModel<T extends CrabEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)"crab"), "main");
    private final ModelPart crab;
    private final ModelPart fullbody;
    private final ModelPart eye;
    private final ModelPart bigclaw;
    private final ModelPart bigclawbottom;
    private final ModelPart bigclawtop;
    private final ModelPart smallclaw;
    private final ModelPart antenna;
    private final ModelPart rantenna;
    private final ModelPart rantenna2;
    private final ModelPart bodybase;
    private final ModelPart legs;
    private final ModelPart rlegs;
    private final ModelPart rleg1;
    private final ModelPart rleg2;
    private final ModelPart rleg3;
    private final ModelPart llegs;
    private final ModelPart lleg1;
    private final ModelPart lleg2;
    private final ModelPart lleg3;

    public CrabModel(ModelPart root) {
        this.crab = root.getChild("crab");
        this.fullbody = this.crab.getChild("fullbody");
        this.eye = this.fullbody.getChild("eye");
        this.bigclaw = this.fullbody.getChild("bigclaw");
        this.bigclawbottom = this.bigclaw.getChild("bigclawbottom");
        this.bigclawtop = this.bigclaw.getChild("bigclawtop");
        this.smallclaw = this.fullbody.getChild("smallclaw");
        this.antenna = this.fullbody.getChild("antenna");
        this.rantenna = this.antenna.getChild("rantenna");
        this.rantenna2 = this.antenna.getChild("rantenna2");
        this.bodybase = this.fullbody.getChild("bodybase");
        this.legs = this.crab.getChild("legs");
        this.rlegs = this.legs.getChild("rlegs");
        this.rleg1 = this.rlegs.getChild("rleg1");
        this.rleg2 = this.rlegs.getChild("rleg2");
        this.rleg3 = this.rlegs.getChild("rleg3");
        this.llegs = this.legs.getChild("llegs");
        this.lleg1 = this.llegs.getChild("lleg1");
        this.lleg2 = this.llegs.getChild("lleg2");
        this.lleg3 = this.llegs.getChild("lleg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition crab = partdefinition.addOrReplaceChild("crab", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)0.5f));
        PartDefinition fullbody = crab.addOrReplaceChild("fullbody", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-1.5f, (float)-3.5f));
        PartDefinition eye = fullbody.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(5, 4).addBox(5.5f, -1.5f, 0.0f, 1.0f, 1.0f, 0.01f, new CubeDeformation(0.0f)).texOffs(5, 5).addBox(-0.5f, -1.5f, 0.0f, 1.0f, 1.0f, 0.01f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bigclaw = fullbody.addOrReplaceChild("bigclaw", CubeListBuilder.create(), PartPose.offset((float)8.5165f, (float)0.0121f, (float)4.7325f));
        PartDefinition bigclawbottom = bigclaw.addOrReplaceChild("bigclawbottom", CubeListBuilder.create(), PartPose.offset((float)0.2405f, (float)-0.0456f, (float)-0.4621f));
        PartDefinition bigclawbottom_r1 = bigclawbottom.addOrReplaceChild("bigclawbottom_r1", CubeListBuilder.create().texOffs(16, 15).addBox(-1.9052f, 0.1072f, -6.8775f, 4.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1835f, (float)-0.5658f, (float)0.0179f));
        PartDefinition bigclawtop = bigclaw.addOrReplaceChild("bigclawtop", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bigclawtop_r1 = bigclawtop.addOrReplaceChild("bigclawtop_r1", CubeListBuilder.create().texOffs(0, 22).addBox(-1.9506f, -2.8472f, -7.3965f, 4.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1835f, (float)-0.5658f, (float)0.0179f));
        PartDefinition smallclaw = fullbody.addOrReplaceChild("smallclaw", CubeListBuilder.create(), PartPose.offset((float)-2.5396f, (float)1.2184f, (float)4.2473f));
        PartDefinition smallclaw_r1 = smallclaw.addOrReplaceChild("smallclaw_r1", CubeListBuilder.create().texOffs(0, 12).addBox(-1.2717f, -1.1118f, -4.1902f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1835f, (float)0.5658f, (float)-0.0179f));
        PartDefinition antenna = fullbody.addOrReplaceChild("antenna", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-0.0231f, (float)-0.1503f));
        PartDefinition rantenna = antenna.addOrReplaceChild("rantenna", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition rantenna_r1 = rantenna.addOrReplaceChild("rantenna_r1", CubeListBuilder.create().texOffs(4, 2).addBox(-0.5f, -1.0f, -0.2f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0231f, (float)0.1503f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition rantenna2 = antenna.addOrReplaceChild("rantenna2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rantenna2_r1 = rantenna2.addOrReplaceChild("rantenna2_r1", CubeListBuilder.create().texOffs(4, 2).addBox(-0.5f, -1.0f, -0.2f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0231f, (float)0.1503f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition bodybase = fullbody.addOrReplaceChild("bodybase", CubeListBuilder.create().texOffs(0, 1).mirror().addBox(-4.5f, -2.0f, -3.5f, 9.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)1.5f, (float)3.5f));
        PartDefinition legs = crab.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)-4.9759f, (float)2.5095f, (float)0.0f));
        PartDefinition rlegs = legs.addOrReplaceChild("rlegs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rleg1 = rlegs.addOrReplaceChild("rleg1", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition rleg1_r1 = rleg1.addOrReplaceChild("rleg1_r1", CubeListBuilder.create().texOffs(-1, 0).addBox(-2.4129f, -0.0617f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.829f));
        PartDefinition rleg2 = rlegs.addOrReplaceChild("rleg2", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition rleg2_r1 = rleg2.addOrReplaceChild("rleg2_r1", CubeListBuilder.create().texOffs(-1, 1).addBox(-2.4129f, -0.0617f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.829f));
        PartDefinition rleg3 = rlegs.addOrReplaceChild("rleg3", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-1.0f, (float)2.0f));
        PartDefinition rleg3_r1 = rleg3.addOrReplaceChild("rleg3_r1", CubeListBuilder.create().texOffs(-1, 0).addBox(-2.4129f, -0.0617f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.829f));
        PartDefinition llegs = legs.addOrReplaceChild("llegs", CubeListBuilder.create(), PartPose.offset((float)9.9518f, (float)0.0f, (float)0.0f));
        PartDefinition lleg1 = llegs.addOrReplaceChild("lleg1", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition lleg1_r1 = lleg1.addOrReplaceChild("lleg1_r1", CubeListBuilder.create().texOffs(-1, 0).addBox(0.4129f, -0.0617f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.829f));
        PartDefinition lleg2 = llegs.addOrReplaceChild("lleg2", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition lleg2_r1 = lleg2.addOrReplaceChild("lleg2_r1", CubeListBuilder.create().texOffs(-1, 1).addBox(0.4129f, -0.0617f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.829f));
        PartDefinition lleg3 = llegs.addOrReplaceChild("lleg3", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-1.0f, (float)2.0f));
        PartDefinition lleg3_r1 = lleg3.addOrReplaceChild("lleg3_r1", CubeListBuilder.create().texOffs(-1, 0).addBox(0.4129f, -0.0617f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.829f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CrabEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(CrabAnimations.walk, limbSwing, limbSwingAmount, 2.0f, 5.0f);
        this.animate(entity.idleAnimationState, CrabAnimations.idle, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.crab.yRot = headYaw * ((float)Math.PI / 180);
        this.crab.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.crab.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.crab;
    }
}

