/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.ModRenderTypes;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.common.block.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class CannonTrajectoryRenderer {
    public static void render(CannonBlockTile tile, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, float partialTicks) {
        BlockHitResult bh;
        HitResult hitResult;
        if (CannonController.access == null || CannonController.access.getInternalCannon() != tile) {
            return;
        }
        if (CannonController.hit == null || CannonController.trajectory == null || !CannonController.showsTrajectory) {
            return;
        }
        boolean rendersRed = !tile.readyToFire();
        Vec3 cannonPos = CannonController.access.getCannonGlobalPosition(partialTicks);
        Minecraft mc = Minecraft.getInstance();
        boolean debug = !mc.showOnlyReducedInfo() && mc.getEntityRenderDispatcher().shouldRenderHitBoxes();
        poseStack.pushPose();
        float yaw = tile.getYaw(partialTicks) * ((float)Math.PI / 180);
        poseStack.mulPose(Axis.YP.rotation(-yaw));
        boolean hitAir = CannonController.shootingMode == ShootingMode.STRAIGHT || CannonController.trajectory.miss() || mc.level.getBlockState(CannonController.trajectory.getHitPos(cannonPos, yaw)).isAir();
        CannonTrajectoryRenderer.renderArrows(poseStack, buffer, partialTicks, CannonController.trajectory, hitAir, rendersRed);
        poseStack.popPose();
        if (!hitAir && (hitResult = CannonController.hit) instanceof BlockHitResult && (bh = (BlockHitResult)hitResult).getDirection() == Direction.UP) {
            CannonTrajectoryRenderer.renderTargetCircle(poseStack, buffer, rendersRed, CannonController.trajectory.getHitLocation(Vec3.ZERO, yaw), partialTicks);
        }
        if (!hitAir && debug && (hitResult = CannonController.hit) instanceof BlockHitResult) {
            bh = (BlockHitResult)hitResult;
            poseStack.mulPose(Axis.YP.rotationDegrees(-CannonController.access.getCannonGlobalYawOffset(partialTicks)));
            CannonTrajectoryRenderer.renderBlockReticule(poseStack, buffer, cannonPos, bh);
        }
    }

    private static void renderBlockReticule(PoseStack poseStack, MultiBufferSource buffer, Vec3 pos, BlockHitResult bh) {
        poseStack.pushPose();
        BlockPos targetPos = bh.getBlockPos();
        VertexConsumer lines = buffer.getBuffer(RenderType.lines());
        Vec3 distance1 = targetPos.getCenter().subtract(pos);
        AABB bb = new AABB(distance1, distance1.add(1.0, 1.0, 1.0)).inflate(0.01);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)lines, (AABB)bb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        poseStack.popPose();
    }

    private static void renderTargetCircle(PoseStack poseStack, MultiBufferSource buffer, boolean red, Vec3 targetPos, float partialTicks) {
        poseStack.pushPose();
        Material circleMaterial = red ? ModMaterials.CANNON_TARGET_RED_MATERIAL : ModMaterials.CANNON_TARGET_MATERIAL;
        VertexConsumer circleBuilder = circleMaterial.buffer(buffer, RenderType::entityCutout);
        poseStack.translate(targetPos.x, targetPos.y + 0.05, targetPos.z);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        int lu = 240;
        int lv = 0xF00000;
        VertexUtil.addQuad((VertexConsumer)circleBuilder, (PoseStack)poseStack, (float)-2.0f, (float)-2.0f, (float)2.0f, (float)2.0f, (int)lu, (int)lv);
        poseStack.popPose();
    }

    private static void renderTargetLine(PoseStack poseStack, MultiBufferSource buffer, Vec2 target) {
        VertexConsumer consumer = buffer.getBuffer(RenderType.lines());
        PoseStack.Pose pose = poseStack.last();
        consumer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(255, 0, 0, 255).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.0f, target.y, -target.x).setColor(255, 0, 0, 255).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.01f, target.y, -target.x).setColor(255, 0, 0, 255).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, 0.01f, 0.0f, 0.0f).setColor(255, 0, 0, 255).setNormal(pose, 0.0f, 0.0f, 1.0f);
    }

    private static void renderArrows(PoseStack poseStack, MultiBufferSource buffer, float partialTicks, CannonTrajectory trajectory, boolean hitAir, boolean red) {
        float finalTime = (float)trajectory.finalTime();
        if (finalTime > 100000.0f) {
            Supplementaries.error();
            return;
        }
        poseStack.pushPose();
        float scale = 1.0f;
        float size = 0.15625f * scale;
        VertexConsumer consumer = buffer.getBuffer(red ? ModRenderTypes.CANNON_TRAJECTORY_RED : ModRenderTypes.CANNON_TRAJECTORY);
        Matrix4f matrix = poseStack.last().pose();
        float py = 0.0f;
        float px = 0.0f;
        float d = (float)(-(System.currentTimeMillis() % 1000L)) / 1000.0f;
        float step = finalTime / (float)((int)finalTime);
        float maxT = finalTime + (hitAir ? 0.0f : step);
        for (float t = step; t < maxT; t += step) {
            float textureStart = d % 1.0f;
            consumer.addVertex(matrix, -size, py, px).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, textureStart);
            consumer.addVertex(matrix, size, py, px).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.3125f, textureStart);
            double ny = trajectory.getY(t);
            double nx = -trajectory.getX(t);
            float dis = (float)Mth.length((double)(nx - (double)px), (double)(ny - (double)py)) / scale;
            float textEnd = textureStart + dis;
            d += dis;
            py = (float)ny;
            px = (float)nx;
            boolean alpha = !(t + step >= maxT);
            consumer.addVertex(matrix, size, py, px).setColor(1.0f, 1.0f, 1.0f, (float)alpha).setUv(0.3125f, textEnd);
            consumer.addVertex(matrix, -size, py, px).setColor(1.0f, 1.0f, 1.0f, (float)alpha).setUv(0.0f, textEnd);
        }
        poseStack.popPose();
    }
}

