/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.funny;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.JarredRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.PickleModel;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;

public class PickleRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PickleModel<AbstractClientPlayer>> {
    public static PickleRenderer INSTANCE = null;
    protected float axisFacing = 0.0f;
    protected boolean wasCrouching = false;

    public PickleRenderer(EntityRendererProvider.Context context) {
        super(context, new PickleModel(context.bakeLayer(ClientRegistry.PICKLE_MODEL)), 0.0125f);
        this.shadowStrength = 0.0f;
        this.shadowRadius = 0.0f;
        this.addLayer((RenderLayer)new PlayerItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new PickleModel.PickleArmor(this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.addLayer((RenderLayer)new PickleModel.PickleElytra(this, context.getModelSet()));
        this.addLayer((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(AbstractClientPlayer player) {
        return ModTextures.SEA_PICKLE_RICK;
    }

    protected boolean shouldShowName(AbstractClientPlayer player) {
        return !player.isCrouching() && super.shouldShowName((LivingEntity)player);
    }

    protected void scale(AbstractClientPlayer player, PoseStack stack, float partialTickTime) {
        stack.scale(0.5f, 0.5f, 0.5f);
    }

    public void render(AbstractClientPlayer player, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.setModelProperties(player);
        if (this.wasCrouching) {
            float f = (Mth.rotLerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) + this.axisFacing) % 360.0f;
            matrixStack.mulPose(Axis.YP.rotationDegrees(f));
        }
        super.render((LivingEntity)player, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public Vec3 getRenderOffset(AbstractClientPlayer player, float partialTicks) {
        return new Vec3(0.0, -0.25, 0.0);
    }

    private void setModelProperties(AbstractClientPlayer player) {
        PlayerModel pickleModel = (PlayerModel)this.getModel();
        pickleModel.setAllVisible(false);
        boolean c = player.isCrouching();
        pickleModel.body.visible = true;
        pickleModel.leftArm.visible = !c;
        pickleModel.rightArm.visible = !c;
        pickleModel.leftLeg.visible = !c;
        pickleModel.rightLeg.visible = !c;
        pickleModel.head.visible = !c;
        boolean bl = pickleModel.hat.visible = !c;
        if (this.wasCrouching != c && c) {
            this.axisFacing = -player.getDirection().toYRot();
        }
        this.wasCrouching = c;
        HumanoidModel.ArmPose poseRightArm = PickleRenderer.getArmPose(player, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose poseLeftArm = PickleRenderer.getArmPose(player, InteractionHand.OFF_HAND);
        if (poseRightArm.isTwoHanded()) {
            HumanoidModel.ArmPose armPose = poseLeftArm = player.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (player.getMainArm() == HumanoidArm.RIGHT) {
            pickleModel.rightArmPose = poseRightArm;
            pickleModel.leftArmPose = poseLeftArm;
        } else {
            pickleModel.rightArmPose = poseLeftArm;
            pickleModel.leftArmPose = poseRightArm;
        }
    }

    protected static HumanoidModel.ArmPose getArmPose(AbstractClientPlayer player, InteractionHand hand) {
        return JarredRenderer.getArmPose(player, hand);
    }

    protected void renderNameTag(AbstractClientPlayer player, Component displayName, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTick) {
        Scoreboard scoreboard;
        Objective objective;
        double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)player);
        poseStack.pushPose();
        if (d0 < 100.0 && (objective = (scoreboard = player.getScoreboard()).getDisplayObjective(DisplaySlot.BELOW_NAME)) != null) {
            ScoreAccess score = scoreboard.getOrCreatePlayerScore((ScoreHolder)player, objective);
            super.renderNameTag((Entity)player, (Component)Component.literal((String)Integer.toString(score.get())).append(" ").append(objective.getDisplayName()), poseStack, buffer, packedLight, partialTick);
            poseStack.translate(0.0, (double)0.25875f, 0.0);
        }
        super.renderNameTag((Entity)player, displayName, poseStack, buffer, packedLight, partialTick);
        poseStack.popPose();
    }

    protected void setupRotations(AbstractClientPlayer player, PoseStack poseStack, float bob, float yBodyRot, float partialTicks, float scale) {
        float f = player.getSwimAmount(partialTicks);
        if (player.isFallFlying()) {
            super.setupRotations((LivingEntity)player, poseStack, bob, yBodyRot, partialTicks, scale);
            float f1 = (float)player.getFallFlyingTicks() + partialTicks;
            float inclination = Mth.clamp((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!player.isAutoSpinAttack()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(inclination * (-90.0f - player.getXRot())));
            }
            Vec3 vector3d = player.getViewVector(partialTicks);
            Vec3 vector3d1 = player.getDeltaMovement();
            double d0 = vector3d1.horizontalDistanceSqr();
            double d1 = vector3d.horizontalDistanceSqr();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.x * vector3d.x + vector3d1.z * vector3d.z) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.x * vector3d.z - vector3d1.z * vector3d.x;
                poseStack.mulPose(Axis.YP.rotation((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.setupRotations((LivingEntity)player, poseStack, bob, yBodyRot, partialTicks, scale);
            float f3 = player.isInWater() ? -90.0f - player.getXRot() : -90.0f;
            float f4 = Mth.lerp((float)f, (float)0.0f, (float)f3);
            poseStack.mulPose(Axis.XP.rotationDegrees(f4));
            if (player.isVisuallySwimming()) {
                poseStack.translate(0.0, -0.25, 0.25);
            }
        } else {
            super.setupRotations((LivingEntity)player, poseStack, bob, yBodyRot, partialTicks, scale);
        }
    }
}

