/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.Nullable;

public class DirectionalSlabBlock
extends SlabBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public DirectionalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = context.getLevel().getBlockState(blockPos);
        BlockState newState = super.getStateForPlacement(context);
        if (blockState.getBlock() == this) {
            if (blockState.getValue((Property)TYPE) == SlabType.BOTTOM) {
                return (BlockState)newState.setValue(AXIS, (Comparable)(blockState.getValue(AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
            }
            return newState;
        }
        return (BlockState)newState.setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(AXIS, (Comparable)(state.getValue(AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
    }
}

