/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeKnotBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.RopeKnotBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RopeKnotBlock
extends AbstractRopeKnotBlock
implements IRopeConnection {
    public static final VoxelShape SIDE_SHAPE = Block.box((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);

    public RopeKnotBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new RopeKnotBlockTile(pPos, pState);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        BlockState newState = (BlockState)state.setValue((Property)RopeBlock.FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.shouldConnectToFace(state, facingState, facingPos, facing, (LevelReader)world)));
        BlockEntity blockEntity = world.getBlockEntity(currentPos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            BlockState newFacing;
            BlockState newHeld;
            BlockEntity blockEntity2;
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            BlockState oldHeld = tile.getHeldBlock();
            RopeKnotBlockTile otherTile = null;
            if (facingState.is(ModRegistry.ROPE_KNOT.get()) && (blockEntity2 = world.getBlockEntity(facingPos)) instanceof RopeKnotBlockTile) {
                RopeKnotBlockTile te2;
                otherTile = te2 = (RopeKnotBlockTile)blockEntity2;
                facingState = otherTile.getHeldBlock();
            }
            if ((newHeld = null) == null) {
                newHeld = oldHeld.updateShape(facing, facingState, world, currentPos, facingPos);
            }
            if (!(facingState.getBlock() instanceof IRopeConnection) && (newFacing = facingState.updateShape(facing.getOpposite(), newHeld, world, facingPos, currentPos)) != facingState) {
                if (otherTile != null) {
                    otherTile.setHeldBlock(newFacing);
                    otherTile.setChanged();
                } else {
                    world.setBlock(facingPos, newFacing, 2);
                }
            }
            ModBlockProperties.PostType type = ModBlockProperties.PostType.get(newHeld);
            if (newHeld != oldHeld) {
                tile.setHeldBlock(newHeld);
                tile.setChanged();
            }
            if (newState != state) {
                tile.recalculateShapes(newState);
            }
            if (type != null) {
                newState = (BlockState)newState.setValue((Property)POST_TYPE, (Comparable)((Object)type));
            }
        }
        return newState;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof ShearsItem) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof RopeKnotBlockTile) {
                RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
                RopeKnotBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModRegistry.ROPE.get()));
                level.playSound(null, pos, SoundEvents.SNOW_GOLEM_SHEAR, SoundSource.PLAYERS, 0.8f, 1.3f);
                level.setBlock(pos, tile.getHeldBlock(), 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.getBlock().getCloneItemStack(level, pos, state);
        }
        return super.getCloneItemStack(level, pos, state);
    }

    @Override
    public boolean canSideAcceptConnection(BlockState state, Direction direction) {
        if (state.getValue(AbstractRopeKnotBlock.AXIS) == Direction.Axis.Y) {
            return direction.getAxis() != Direction.Axis.Y;
        }
        return direction.getAxis() == Direction.Axis.Y;
    }

    @Override
    public VoxelShape getSideShape() {
        return SIDE_SHAPE;
    }
}

