/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import java.util.EnumSet;
import net.mehvahdjukaar.supplementaries.common.entities.data.LivingEntityTamable;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class FollowLivingOwnerGoal
extends Goal {
    private final Mob mob;
    @Nullable
    public LivingEntity owner;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public FollowLivingOwnerGoal(Mob mob, double speedModifier, float startDistance, float stopDistance) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.navigation = mob.getNavigation();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(mob.getNavigation() instanceof GroundPathNavigation) && !(mob.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean canUse() {
        LivingEntityTamable livingTamable = (LivingEntityTamable)ModEntities.LIVING_TAMABLE.getOrCreate((Object)this.mob);
        LivingEntity owner = livingTamable.getOwner(this.mob);
        if (owner == null) {
            return false;
        }
        if (livingTamable.unableToMoveToOwner(this.mob)) {
            return false;
        }
        if (this.mob.distanceToSqr((Entity)owner) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        LivingEntityTamable livingTamable = (LivingEntityTamable)ModEntities.LIVING_TAMABLE.getOrCreate((Object)this.mob);
        if (this.navigation.isDone()) {
            return false;
        }
        if (livingTamable.unableToMoveToOwner(this.mob)) {
            return false;
        }
        return !(this.mob.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
        this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.mob.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            this.navigation.moveTo((Entity)this.owner, this.speedModifier);
        }
    }
}

