/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_markers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ColoredDecoration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;

public class ColoredMarker
extends MLMapMarker<ColoredDecoration> {
    public static final MapCodec<ColoredMarker> DIRECT_CODEC = RecordCodecBuilder.mapCodec(i -> ColoredMarker.baseCodecGroup((RecordCodecBuilder.Instance)i).and((App)DyeColor.CODEC.fieldOf("color").forGetter(m -> m.color)).apply((Applicative)i, ColoredMarker::new));
    private final DyeColor color;

    public ColoredMarker(Holder<MLMapDecorationType<?, ?>> type, BlockPos pos, float rotation, Optional<Component> component, Optional<Boolean> shouldRefresh, Optional<Boolean> shouldSave, boolean preventsExtending, DyeColor color) {
        super(type, pos, rotation, component, shouldRefresh, shouldSave, preventsExtending);
        this.color = color;
    }

    public ColoredMarker(Holder<MLMapDecorationType<?, ?>> type, BlockPos pos, DyeColor color) {
        this(type, pos, null, color);
    }

    public ColoredMarker(Holder<MLMapDecorationType<?, ?>> type, BlockPos pos, @Nullable Component name, DyeColor color) {
        this(type, pos, 0.0f, Optional.ofNullable(name), Optional.empty(), Optional.empty(), false, color);
    }

    public ColoredDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new ColoredDecoration(this.getType(), mapX, mapY, rot, this.name, this.color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!super.equals(o)) return false;
        if (!(o instanceof ColoredMarker)) return false;
        ColoredMarker marker = (ColoredMarker)((Object)o);
        if (this.color != marker.color) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.pos, this.name, this.color);
    }
}

