/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class RandomSpreadStructurePlacementWithExclusion
extends RandomSpreadStructurePlacement {
    private final List<StructurePlacement.ExclusionZone> exclusionZones;
    public static final MapCodec<RandomSpreadStructurePlacementWithExclusion> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Vec3i.offsetCodec((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.ZERO).forGetter(rec$ -> ((RandomSpreadStructurePlacementWithExclusion)((Object)((Object)((Object)rec$)))).locateOffset()), (App)StructurePlacement.FrequencyReductionMethod.CODEC.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(rec$ -> ((RandomSpreadStructurePlacementWithExclusion)((Object)((Object)((Object)rec$)))).frequencyReductionMethod()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((RandomSpreadStructurePlacementWithExclusion)((Object)((Object)((Object)rec$)))).frequency())), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("salt").forGetter(rec$ -> ((RandomSpreadStructurePlacementWithExclusion)((Object)((Object)((Object)rec$)))).salt()), (App)StructurePlacement.ExclusionZone.CODEC.listOf().optionalFieldOf("exclusion_zones", List.of()).forGetter(RandomSpreadStructurePlacementWithExclusion::exclusionZones), (App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::separation), (App)RandomSpreadType.CODEC.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::spreadType)).apply((Applicative)i, RandomSpreadStructurePlacementWithExclusion::new)).validate(RandomSpreadStructurePlacementWithExclusion::validate);

    public RandomSpreadStructurePlacementWithExclusion(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, List<StructurePlacement.ExclusionZone> exclusionZones, int spacing, int separation, RandomSpreadType spreadType) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, Optional.empty(), spacing, separation, spreadType);
        this.exclusionZones = exclusionZones;
    }

    static boolean isPlacementForbidden(StructurePlacement.ExclusionZone zone, ChunkGeneratorStructureState structureState, int x, int z) {
        return structureState.hasStructureChunkInRange(zone.otherSet(), x, z, zone.chunkCount());
    }

    public boolean applyInteractionsWithOtherStructures(ChunkGeneratorStructureState structureState, int x, int z) {
        for (StructurePlacement.ExclusionZone zone : this.exclusionZones) {
            if (!RandomSpreadStructurePlacementWithExclusion.isPlacementForbidden(zone, structureState, x, z)) continue;
            return false;
        }
        return true;
    }

    public List<StructurePlacement.ExclusionZone> exclusionZones() {
        return this.exclusionZones;
    }

    private static DataResult<RandomSpreadStructurePlacementWithExclusion> validate(RandomSpreadStructurePlacementWithExclusion placement) {
        return placement.spacing() <= placement.separation() ? DataResult.error(() -> "Spacing has to be larger than separation") : DataResult.success((Object)((Object)placement));
    }
}

