/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.FacingBlock;
import net.satisfy.meadow.core.block.TiledStoveBlockBench;
import net.satisfy.meadow.core.block.TiledStoveBlockFireplace;
import net.satisfy.meadow.core.block.TiledStoveBlockSmoker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TiledStoveBlock
extends FacingBlock {
    public static final BooleanProperty CONNECTED_UP = BooleanProperty.create((String)"connected_up");
    public static final BooleanProperty CONNECTED_DOWN = BooleanProperty.create((String)"connected_down");
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    public static final VoxelShape SHAPE_BIG = Shapes.or((VoxelShape)TiledStoveBlockBench.SHAPE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));

    public TiledStoveBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CONNECTED_DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTED_UP, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)CONNECTED_DOWN)).booleanValue()) {
            return super.getShape(state, world, pos, context);
        }
        return SHAPE_BIG;
    }

    public boolean isConnected(BlockState state, Direction direction) {
        return (Boolean)state.getValue((Property)(direction == Direction.UP ? CONNECTED_UP : CONNECTED_DOWN));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean up = this.isBlockStove(ctx, Direction.UP);
        boolean down = this.isBlockStove(ctx, Direction.DOWN);
        if (up || down) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CONNECTED_UP, (Comparable)Boolean.valueOf(up))).setValue((Property)CONNECTED_DOWN, (Comparable)Boolean.valueOf(down))).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
        }
        return super.getStateForPlacement(ctx);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!(world.isClientSide() || direction != Direction.DOWN && direction != Direction.UP)) {
            if (!this.isConnected(state, direction)) {
                if (this.isBlockStove(neighborState)) {
                    return (BlockState)state.setValue((Property)(direction == Direction.UP ? CONNECTED_UP : CONNECTED_DOWN), (Comparable)Boolean.valueOf(true));
                }
            } else if (!this.isBlockStove(neighborState)) {
                return (BlockState)state.setValue((Property)(direction == Direction.UP ? CONNECTED_UP : CONNECTED_DOWN), (Comparable)Boolean.valueOf(false));
            }
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CONNECTED_DOWN});
        builder.add(new Property[]{CONNECTED_UP});
        builder.add(new Property[]{LIT});
    }

    public boolean isBlockStove(BlockPlaceContext ctx, Direction direction) {
        return this.isBlockStove(ctx.getLevel().getBlockState(ctx.getClickedPos().relative(direction)));
    }

    public boolean isBlockStove(BlockState blockState) {
        return this.isBlockStove(blockState.getBlock());
    }

    public boolean isBlockStove(Block block) {
        return block instanceof TiledStoveBlockSmoker || block instanceof TiledStoveBlock || block instanceof TiledStoveBlockFireplace;
    }
}

